<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Validator;
use Response;
use Redirect;
use Session;
use App\Verifikasis_k_manager;
use Illuminate\Support\Facades\DB;



class Report_kController extends Controller {



    public function index() {
      $verifikasis_k_manager = DB::table('verifikasi_keuangan_manager')->paginate(10);
      
        return view('verifikasiKeuanganManager.index',['verifikasis_k_manager' => $verifikasis_k_manager]);
    }


      public function create()
    {
       return view('verifikasiKeuanganManager.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $verifikasi_k = new verifikasis_k_manager;  
        return redirect()->route('verifikasiKeuanganManager.index')->with('alert-success','Data Hasbeen Saved');
    }


    public function multiple_upload() {
      // getting all of the post data
      $files = Input::file('images');
      // Making counting of uploaded images
      $file_count = count($files);
      // start count how many uploaded
      $uploadcount = 0;

      foreach ($files as $file) {
        $rules = array('file' => 'required'); //'required|mimes:png,gif,jpeg,txt,pdf,doc'
        $validator = Validator::make(array('file'=> $file), $rules);
        if($validator->passes()){
          $destinationPath = 'verifikasis_k_manager'; // upload folder in public directory
          $filename = $file->getClientOriginalName();
          $upload_success = $file->move($destinationPath, $filename);
          $uploadcount ++;

          // save into database
          $extension = $file->getClientOriginalExtension();
          $entry = new verifikasis_k_manager();
          $entry->mime = $file->getClientMimeType();
          $entry->original_filename = $filename;
          $entry->filename = $file->getFilename().'.'.$extension;
          $entry->status = 'request';
          $entry->save();
        }
      }
      if($uploadcount == $file_count){
        Session::flash('success', 'Upload successfully');
        return Redirect::to('verifikasiKeuanganManager');
      } else {
        return Redirect::to('verifikasiKeuanganManager')->withInput()->withErrors($validator);
      }
    }


     public function destroy($id)
    {
         $verifikasi_k = verifikasis_k_manager::findOrFail($id);
        $verifikasi_k->delete();
        return redirect()->route('verifikasiKeuanganManager.index')->with('alert-success','Data Hasbeen Deleted');  
    }



} 