<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Validator;
use Response;
use Redirect;
use Session;
use App\Uploads;

use DB;

class UploadsController extends Controller {



    public function index() {
      $uploads = Uploads::all();
        return view('upload.index',['uploads' => $uploads]);
    }


      public function create()
    {
       return view('upload.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,['nama'=> 'required',]);

        $upload = new uploads;
        $upload->nama = $request->nama;
        $upload->save();
        return redirect()->route('upload.index')->with('alert-success','Data Hasbeen Saved');
    }


    public function multiple_upload() {
      // getting all of the post data
      $files = Input::file('images');
      // Making counting of uploaded images
      $file_count = count($files);
      // start count how many uploaded
      $uploadcount = 0;

      foreach ($files as $file) {
        $rules = array('file' => 'required'); //'required|mimes:png,gif,jpeg,txt,pdf,doc'
        $validator = Validator::make(array('file'=> $file), $rules);
        if($validator->passes()){
          $destinationPath = 'uploads'; // upload folder in public directory
          $filename = $file->getClientOriginalName();
          $upload_success = $file->move($destinationPath, $filename);
          $uploadcount ++;

          // save into database
          $extension = $file->getClientOriginalExtension();
          $entry = new Uploads();
          $entry->mime = $file->getClientMimeType();
          $entry->original_filename = $filename;
          $entry->filename = $file->getFilename().'.'.$extension;
          $entry->save();
        }
      }
      if($uploadcount == $file_count){
        Session::flash('success', 'Upload successfully');
        return Redirect::to('upload');
      } else {
        return Redirect::to('upload')->withInput()->withErrors($validator);
      }
    }


     public function destroy($id)
    {
         $upload = Uploads::findOrFail($id);
        $upload->delete();
        return redirect()->route('upload.index')->with('alert-success','Data Hasbeen Deleted');  
    }



} 