<?php

namespace App\Http\Controllers;



use App\Http\Request;
use App\Http\Controllers\Controller;
use App\pembayaran;

use Illuminate\Support\Facades\Input;
use DB;
use Excel;

class ExcelController extends Controller
{
    
//IMPORT


      public function getImportPembayaran(){
        return view('excel.importPembayaran');
    }



//EXPORT



    public function getExportPembayaran(){
        $pembayaran=Pembayaran::all();
        Excel::create('Export Data Pembayaran', function($excel) use($pembayaran){
            $excel->sheet('Sheet 1', function($sheet) use($pembayaran){
                $sheet->fromArray($pembayaran);
            });
        })->export('xlsx');
    }




    //POST IMPORT


    public function postImportPembayaran(){

        Excel::load(Input::file('pembayaran'),function($reader){
            $reader->each(function($sheet){
                Pembayaran::firstOrCreate($sheet->toArray());
            });
        });

        
        $pembayarans = DB::table('tbl_transaksi')->paginate(10);
        return view('pembayaran.index',['pembayarans' => $pembayarans]);
    }



    //DELETE



     public function deleteAllPembayaran(){
        DB::table('tbl_transaksi')->delete();
        $pembayarans = DB::table('tbl_transaksi')->paginate(10);
        
        return view('pembayaran.index',['pembayarans' => $pembayarans]);
    }

    
}
