<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Validator;
use Response;
use Redirect;
use Session;
use App\Verifikasis_m_manager;
use Illuminate\Support\Facades\DB;



class Report_mController extends Controller {



    public function index() {
      $verifikasis_m_manager = DB::table('verifikasi_masalah_manager')->paginate(10);
      
        return view('verifikasiMasalahManager.index',['verifikasis_m_manager' => $verifikasis_m_manager]);
    }


      public function create()
    {
       return view('verifikasiMasalahManager.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,['nama'=> 'required',]);

        $verifikasi_m = new verifikasis_m_manager;
        $verifikasi_m->nama = $request->nama;
        $verifikasi_m->save();
        return redirect()->route('verifikasiMasalahManager.index')->with('alert-success','Data Hasbeen Saved');
    }


    public function multiple_upload() {
      // getting all of the post data
      $files = Input::file('images');
      // Making counting of uploaded images
      $file_count = count($files);
      // start count how many uploaded
      $uploadcount = 0;

      foreach ($files as $file) {
        $rules = array('file' => 'required'); //'required|mimes:png,gif,jpeg,txt,pdf,doc'
        $validator = Validator::make(array('file'=> $file), $rules);
        if($validator->passes()){
          $destinationPath = 'verifikasis_m_manager'; // upload folder in public directory
          $filename = $file->getClientOriginalName();
          $upload_success = $file->move($destinationPath, $filename);
          $uploadcount ++;

          // save into database
          $extension = $file->getClientOriginalExtension();
          $entry = new verifikasis_m_manager();
          $entry->mime = $file->getClientMimeType();
          $entry->original_filename = $filename;
          $entry->filename = $file->getFilename().'.'.$extension;
          $entry->status = 'request';
          $entry->save();
        }
      }
      if($uploadcount == $file_count){
        Session::flash('success', 'Upload successfully');
        return Redirect::to('verifikasiMasalahManager');
      } else {
        return Redirect::to('verifikasiMasalahManager')->withInput()->withErrors($validator);
      }
    }


     public function destroy($id)
    {
         $verifikasi_m = verifikasis_m_manager::findOrFail($id);
        $verifikasi_m->delete();
        return redirect()->route('verifikasiMasalahManager.index')->with('alert-success','Data Hasbeen Deleted');  
    }



} 