<?php  
	namespace App\Http\Controllers;

	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\DB;

	use App\Http\Requests;
	use App\Models\Person;

	class HomeController extends Controller
	{
		public function index()
    	{
        	$search = \Request::get('search');
            $persons = Person::where('fullname', 'like', '%'.$search.'%')->orderBy('id')->paginate(4);
        	return view('tugas/home', ['persons' => $persons]);
    	}

    	public function show($id)
    	{
    		$persons->id = $request->id;
            $persons->find();

    	   return view('tugas/home', ['persons' => $persons]);
    	}

    	public function create(){
    		return view('tugas.create');
    	}

    	public function store(Request $request){
    		$person = new Person;
    		//$person->id = $request->id;
    		$person->fullname = $request->fullname;
    		$person->idcardnum = $request->idcardnum;
    		$person->birthdate = $request->birthdate;
    		$person->province = $request->province;
    		$person->district = $request->district;
    		$person->sector = $request->sector;
    		$person->cellar = $request->cellar;
    		$person->image = $request->image;
    		$person->save();
    		
    		return redirect()->route('tugas.index')->with('alert-success', 'Data Telah Disimpan');
    	}

        public function update(Request $request, $id)
        {
            $person = Person::findOrFail($id);
            $person->fullname = $request->fullname;
            $person->idcardnum = $request->idcardnum;
            $person->birthdate = $request->birthdate;
            $person->province = $request->province;
            $person->district = $request->district;
            $person->sector = $request->sector;
            $person->cellar = $request->cellar;
            $person->image = $request->image;
            $person->save();

            return redirect()->route('tugas.index')->with('alert-success', 'Data Telah Disimpan');
        }

        public function edit($id)
        {
             $person = Person::findOrFail($id);

             return view('tugas.edit', compact('person'));
        }

        public function destroy($id)
        {   
            $person = Person::findOrFail($id);

            $person->delete();

            return redirect()->route('tugas.index')->with('alert-success', 'Data Telah Dihapus');
        }

        public function search($id)
        {
            $person = Person::find($id);

            return view('tugas/home', ['persons' => $persons]);
        }
	}
?>