@extends('layout')
@section('judul')
Daftar Anggota
@endsection
@section('konten')
<br/>
<div class="row">
	<div class="col-lg-1">
		
	</div>
</div>
<br/>
<section class="panel panel-default">
	<header class="panel-heading">
		<h3>Daftar Anggota</h3>
	</header>
	<div class="table-responsive">
		<table class="table table-striped table-bordered">
			<thead>
				<tr>
				<tr><br></tr>
						<div class="col-lg-10">
							<input type="text" name="search" class="form-control" id="search" placeholder="search">
						</div>
				<tr><a href="{{url('/profileMVC/create')}}" class="btn btn-success">Add Anggota</a><br><br></tr>
					
				</tr>
				<tr>
					<th>ID</th>
					<th>Full Names</th>
					<th>Sex</th>
					<th>Identity Card</th>
					<th>Birth Date</th>
					<th>Province</th>
					<th>District</th>
					<th>Sector</th>
					<th>Image</th>
					<th>Option</th>
				</tr>
			</thead>
			<tbody>
				@foreach($data as $client)
				<tr>
					<td>{{$client->id}}</td>
					<td>{{$client->name}}</td>
					<td>{{$client->sex}}</td>
					<td>{{$client->idcard}}</td>
					<td>{{$client->birthdate}}</td>
					<td>{{$client->province}}</td>
					<td>{{$client->district}}</td>
					<td>{{$client->sector}}</td>
					<td><img src="images/<?php echo $client->image; ?>" style="max-width: 10em; max-height: 10em;"></td>
					<td>
						<a href="{{url('profileMVC/'.$client->id.'/edit')}}" class="btn btn-info" title="edit {{$client->name}}"><i class="glyphicon glyphicon-edit"></i></a>

						<form action="{{ url('profileMVC/'.$client->id) }}" method="post">
							{{csrf_field()}} 
							<br/>
							<input type="hidden" name="_method" value="delete">
							<button type="submit" class="btn btn-warning" title="delete {{$client->name}}"><i class="glyphicon glyphicon-trash"></i></button>
						</form>
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>

</section>	
@endsection
@section('script')
<script type="text/javascript">
	$(document).ready(function(){
		$('#search').on('keyup',function(){
			$value = $(this).val();
			$.ajax({
				type : 'get',
				url : '{{URL::to('search')}}',
				data : {'search':$value},
				success:function(data){
					$('tbody').html(data);
				}
			});
		});
	});
</script>
@endsection