"""SearchEngine URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.11/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.conf.urls import url, include
    2. Add a URL to urlpatterns:  url(r'^blog/', include('blog.urls'))
"""
from django.conf.urls import url
from django.contrib import admin
from django.urls import include, path
from InvertedIndexSimulator import views

urlpatterns = [
    path('', views.home),
    path('dataframe/', views.dataframe),
    path('preprocessing/', views.preprocessing),
    path('preprocessing2/', views.preprocessing2),
    path('preprocessing3/', views.preprocessing3),
    path('preprocessing4/', views.preprocessing4),
    path('indexing/', views.indexing),
    path('search/', views.search),
    path('index/', views.index),
    path('phrases/', views.phrases),
    path('result/', views.result),
    path('resultphrase/', views.resultphrase),
    path('lyric/<int:id>', views.lyric, name='lyric'),
    
]
