package org.perpus.controller;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import org.perpus.model.Buku;
import org.perpus.dao.BukuDAO;
import org.perpus.dao.BukuDAOImplementation;

/**
 * Servlet implementation class BukuController
 */
@WebServlet("/BukuController")
public class BukuController extends HttpServlet {
	
	private BukuDAO dao;
    private static final long serialVersionUID = 1L;
    public static final String lIST_Buku = "/listBuku.jsp";
    public static final String INSERT_OR_EDIT = "/buku.jsp";
 
	
       
    /**
     * @see HttpServlet#HttpServlet()
     */
    public BukuController() {
        dao = new BukuDAOImplementation();
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		String forward = "";
        String action = request.getParameter( "action" );
 
        if( action.equalsIgnoreCase( "delete" ) ) {
            forward = lIST_Buku;
            int isbn = Integer.parseInt( request.getParameter("isbn") );
            dao.deleteBuku(isbn);
            request.setAttribute("bukus", dao.getAllBukus() );
        }
        else if( action.equalsIgnoreCase( "edit" ) ) {
            forward = INSERT_OR_EDIT;
            int isbn = Integer.parseInt( request.getParameter("isbn") );
            Buku buku = dao.getBukuById(isbn);
            request.setAttribute("buku", buku);
        }
        else if( action.equalsIgnoreCase( "insert" ) ) {
            forward = INSERT_OR_EDIT;
        }
        else {
            forward = lIST_Buku;
            request.setAttribute("bukus", dao.getAllBukus() );
        }
        RequestDispatcher view = request.getRequestDispatcher( forward );
        view.forward(request, response);
	
		
		
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		Buku buku = new Buku();
 
		//buku.setIsbn(0);
		buku.setJudul(request.getParameter("judul"));
		buku.setPengarang(request.getParameter("pengarang"));
		buku.setPenerbit(request.getParameter("penerbit"));
		buku.setTahun(Integer.parseInt(request.getParameter("tahun")));
		buku.setHarga(Integer.parseInt(request.getParameter("harga")));
		String isbn = request.getParameter("isbn");
				
		
        if( isbn == null || isbn.isEmpty() )
            
        	dao.addBuku(buku);
        else {
            buku.setIsbn(Integer.parseInt(isbn));
            dao.updateBuku(buku);
        }
        RequestDispatcher view = request.getRequestDispatcher( lIST_Buku );
        request.setAttribute("bukus", dao.getAllBukus());
        view.forward(request, response);
	}

}
