<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthController;

Route::post('/login', [AuthController::class, 'login']);
Route::post('/register', [AuthController::class, 'register']);
Route::delete('/logout', [AuthController::class, 'logout']);

Route::middleware('auth:api', 'role:admin')->group(function () {
    //User
    Route::get('/user', [AuthController::class, 'getAllUser']);
    Route::get('/user/{id}', [AuthController::class, 'getUserById']);
});

