@if(Auth::check())
    @extends('layouts.layout')
    @include('layouts.header')

    <body class="skin-blue sidebar-mini" style="height: auto;">
    <div class="wrapper" style="height: auto;">
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section id="content-menu" class="content-menu">
                <div class="module-menu-container"></div>
                <ol class="breadcrumb"><li><a href="/"><i class="fa-home"></i> Home</a></li>
                    <li class="active"><i class="fa-bus"></i>Riwayat Pemesanan Bus</li>
                </ol><!-- breadcrumbs -->
            </section>

            <!-- Main content -->
            <section class="content">
                <!-- /.row -->
                <div class="row">
                    <div class="col-xs-12">
                        <div class="box">
                            <div class="box-header">
                                <h3 class="box-title">List Pemesanan</h3>
                                <div class="box-tools">
                                    <form action="{{url('/admin/pemesanan')}}">
                                        <div class="input-group input-group-sm" style="width: 150px;">
                                            <input type="text" name="search" class="form-control pull-right"
                                                   placeholder="Username" id="search" type="text">
                                            <div class="input-group-btn">
                                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body table-responsive no-padding">
                                <table class="table table-hover">
                                    <thead><tr>
                                        <th>Nama Pemesan</th>
                                        <th>Tujuan</th>
                                        <th>Berangkat</th>
                                        <th>Status</th>
                                    </tr></thead>
                                    <tbody>
                                    @foreach($batal as $bata)
                                        <tr>
                                            <td>{{$bata->client_username}}</td>
                                            <td>{{$bata->tujuan}}</td>
                                            <td>{{$bata->berangkat}}</td>
                                            <td><span class="label label-danger">Dibatalkan</span>
                                        </tr>
                                        </form>
                                    @endforeach
                                    @foreach($pemesanan as $pesan)
                                        <tr>
                                            <td>{{$pesan->client_username}}</td>
                                            <td>{{$pesan->tujuan}}</td>
                                            <td>{{$pesan->berangkat}}</td>
                                            <td><span class="label label-info">{{$pesan->status}}</span>
                                        </tr>
                                        </form>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.box-body -->
                        </div>
                        <!-- /.box -->
                    </div>

                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>
    </body>
@endif