<?php

namespace App\Http\Controllers;

use App\Models\Batal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use File;
use App\Http\Requests;
use App\Models\Bus;
use App\Models\Users;
use App\Models\Supir;
use App\Models\Pemesanan;
use App\Models\Konfirmasi;
use App\Models\Jadwal;
use Validator;
use App\Http\Controllers\Controller;
use App\User;
use Image;

class K_SupirController extends Controller
{
    public function pemesanan(){
        $key = Input::get('search');
        $this->data['title'] = 'Pemesanan Bus IT Del';

        if(isset($key)){
            $this->data['pemesanan'] = Pemesanan::where('client_username','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['pemesanan'] = Pemesanan::orderBy('id','desc')->paginate(10);
        }
        $this->data['pemesanan'] = DB::table('pemesanan')->where('status','=','diproses')->get();
        return view('k_supir.pemesanan.index',$this->data);
    }


    public function detailpemesanan($id){
        $this->data['title'] = 'Detail Pemesanan';
        $this->data['pemesanan'] = Pemesanan::find($id);
        return view('k_supir.pemesanan.detail',$this->data);
    }

    public function tolak($id){
        pemesanan::find($id)->delete();
        return redirect(url('/k_supir/pemesanan'))->with('info','Pembatalan pemesanan berhasil dilakukan');
    }

    public function konfirmasi(Request $request, $id){
        $this->data['title'] = 'Detail Pemesanan';
        $this->data['pemesanan'] = Pemesanan::find($id);
        pemesanan::find($id)->delete();

        $input = $request->all();
        Konfirmasi::create($input);
        return redirect(url('/k_supir/pemesanan'))->with('info','Pembatalan Berhasil dilakukan');
    }

    public function storebus(Request $request){
        $this->validate($request, [
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        $input = $request->all();
        $image = $request->file('image');
        $input['image'] = time().'.'.$image->getClientOriginalExtension();

        $destinationPath = public_path('/image');
        $img = Image::make($image->getRealPath());
        $img->resize(300, 300, function ($constraint) {
            $constraint->aspectRatio();
        })->save($destinationPath.'/'.$input['image']);

        if($plat_bus = DB::table('bus')->where('plat_bus' , $input['plat_bus'])->first()){
            return redirect()->back()->with('info','We are so sorry :( .Plat Bus is exists. Please choose another Plat Bus');
        }else{
            Bus::create($input);
            return redirect(url('/k_supir/bus'))->with('info','Data Bus berhasil ditambah');
        }
    }

    public function bus(){
        $key = Input::get('search');
        $this->data['title'] = 'Bus IT Del';
        if(isset($key)){
            $this->data['bus'] = Bus::where('nama_bus','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['bus'] = Bus::orderBy('id','desc')->paginate(10);
        }
        $this->data['total'] = DB::table('bus')->get();
        return view('k_supir.bus.index',$this->data);
    }

    public function detail($id){
        $this->data['title'] = 'Detail Bus';
        $this->data['bus'] = Bus::find($id);
        return view('k_supir.bus.detail',$this->data);
    }
    public function pilih(){
        $key = Input::get('search');
        $this->data['title'] = 'Bus IT Del';
        if(isset($key)){
            $this->data['bus'] = Bus::where('nama_bus','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['bus'] = Bus::orderBy('id','desc')->paginate(10);
        }
        $this->data['total'] = DB::table('bus')->get();
        return view('k_supir.pemesanan.pilih',$this->data);
    }
    public function pilih_bus($id){
        $key = Input::get('search');
        $this->data['bus'] = Bus::find($id);
        $this->data['title'] = 'Pilih Bus IT Del';
        return view('k_supir.pemesanan.pilih_bus',$this->data);
    }
    public function history(){
        $key = Input::get('search');
        $this->data['title'] = 'Pemesanan Bus IT Del';

        if(isset($key)){
            $this->data['konfirmasi'] = Konfirmasi::where('client_username','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['konfirmasi'] = Konfirmasi::orderBy('id','desc')->paginate(10);
        }
        $this->data['konfirmasi'] = DB::table('konfirmasi')->where('status','=','disetujui')->get();
        return view('k_supir.history.index',$this->data);
    }

    public function history_detail($id){
        $this->data['title'] = 'Detail Pemesanan';
        $this->data['konfirmasi'] = Konfirmasi::find($id);
        return view('k_supir.history.detail',$this->data);
    }

    public function supir(){
        $key = Input::get('search');
        $this->data['title'] = 'Supir Bus IT Del';
        if(isset($key)){
            $this->data['supir'] = Supir::where('nama_bus','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['supir'] = Supir::orderBy('id','desc')->paginate(10);
        }
        $this->data['total'] = DB::table('supir')->get();
        return view('k_supir.supir.index',$this->data);
    }

    public function detailsupir($id){
        $this->data['title'] = 'Detail Supir';
        $this->data['supir'] = Supir::find($id);
        return view('k_supir.supir.detail',$this->data);
    }


    public function jadwal(){
        $key = Input::get('search');
        $this->data['title'] = 'Jadwal Supir IT Del';
        if(isset($key)){
            $this->data['jadwal'] = Jadwal::where('hari','like','%'.$key.'%')->orderBy('id','asc')->paginate(10);
            $this->data['supir'] = Supir::where('nama_bus','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['jadwal'] = Jadwal::orderBy('id','asc')->paginate(10);
            $this->data['supir'] = Supir::orderBy('id','desc')->paginate(10);
        }
        $this->data['total'] = DB::table('jadwal')->get();
        $this->data['total'] = DB::table('supir')->get();
        return view('k_supir.supir.jadwal',$this->data);
    }

    public function update_jadwal(){
        $key = Input::get('search');
        $this->data['title'] = 'Jadwal Supir IT Del';
        if(isset($key)){
            $this->data['jadwal'] = Jadwal::where('hari','like','%'.$key.'%')->orderBy('id','asc')->paginate(10);
            $this->data['supir'] = Supir::where('nama_bus','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['jadwal'] = Jadwal::orderBy('id','asc')->paginate(10);
            $this->data['supir'] = Supir::orderBy('id','desc')->paginate(10);
        }
        $this->data['total'] = DB::table('jadwal')->get();
        $this->data['total'] = DB::table('supir')->get();
        return view('k_supir.supir.update_jadwal',$this->data);
    }

    public function invoice_print(){
        $key = Input::get('search');
        $this->data['title'] = 'Jadwal Supir IT Del';
        if(isset($key)){
            $this->data['jadwal'] = Jadwal::where('hari','like','%'.$key.'%')->orderBy('id','asc')->paginate(10);
            $this->data['supir'] = Supir::where('nama_bus','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['jadwal'] = Jadwal::orderBy('id','asc')->paginate(10);
            $this->data['supir'] = Supir::orderBy('id','desc')->paginate(10);
        }
        $this->data['total'] = DB::table('jadwal')->get();
        $this->data['total'] = DB::table('supir')->get();

        return view('k_supir.supir.invoice-print',$this->data);
    }
}
