﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Move : MonoBehaviour {

	public float speed = 10f;
	public bool finish = false;
	public string kindOfMove;
	public float max;
	public float min;

	[SerializeField]
	private Transform childTransform;

	void Update () {
		if (kindOfMove == "Horizontal") {
			GerakHorizontal ();
		} else {
			GerakVertical ();	
		}

	}
		
	public virtual void GerakHorizontal(){
		Vector2 posisiSementara = posisi;

		if (finish) {
			posisiSementara.x += speed * Time.deltaTime;
			if (posisiSementara.x > max) {
				finish = false;
			}
		}else{
			posisiSementara.x -= speed * Time.deltaTime;
			if (posisiSementara.x < min) {

				finish  = true;

			}
		}
		posisi = posisiSementara;
		childTransform = transform;
	}

	public virtual void GerakVertical(){
		Vector2 posisiSementara = posisi;
		if (finish) {
			posisiSementara.y += speed * Time.deltaTime;
			if (posisiSementara.y > max) {
				finish = false;
			}
		}else{
			posisiSementara.y -= speed * Time.deltaTime;
			if (posisiSementara.y < min) {

				finish  = true;

			}
		}
		posisi = posisiSementara;
		childTransform = transform;
	}

	public Vector2 posisi{
		get{
			return(this.transform.position);
		}
		set{
			this.transform.position = value;
		}
	}

	private void OnTriggerEnter2D(Collider2D collision){
		if (collision.gameObject.tag == "Player") {
			collision.transform.SetParent (childTransform);
		}
	}

	private void OnTriggerExit2D(Collider2D collision){
		collision.transform.SetParent (null);
	}
}
