<?php

/*
 * Taken from
 * https://github.com/laravel/framework/blob/5.3/src/Illuminate/Auth/Console/stubs/make/controllers/HomeController.stub
 */

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use App\User;
use App\Classes;
use App\Course;
use App\Room;
use DB;
/**
 * Class HomeController
 * @package App\Http\Controllers
 */
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return Response
     */
    public function index()
    {
        $totalUser = User::count();
        $totalClass = Classes::count();
        $totalCourses = Course::count();
        $totalRooms = Room::count();
        return view('adminlte::home')->with('totalUser', $totalUser)
                                     ->with('totalClass', $totalClass)
                                     ->with('totalCourses', $totalCourses)
                                     ->with('totalRooms', $totalRooms);
    }
}