@extends('adminlte::layouts.app')

@section('htmlheader_title')
	Class
@endsection

@section('main-content')
	<div class="container-fluid spark-screen">
		<div class="row">
			<div class="col-md-12">
				<h2 class="page-header">{{ $class->name }}'s Courses</h2>

					<div class="panel panel-default">
					    <div class="panel-heading">
					        List of Courses
					    </div>

					    <div class="panel-body">
					        <div class="">
					            <table class="table table-striped" id="thegrid">
					                <thead>
					                    <tr>
					                        <th>ID</th>
					                        <th>Name</th>
					                        <th style="width:150px">Action</th>
					                        <!-- <th style="width:50px"></th> -->
					                    </tr>
					                </thead>
					                <tbody>
					                    @foreach ($courses as $course)
					                        <tr>
					                            <td>{{ $course->course_id }}</td>
					                            <td>{{ $course->name }}</td>
					                            <td> 
					                                <a href="{{ url('class/resign') }}/{{$course->class_id}}/{{$course->course_id}} " class="btn btn-danger" onclick="return confirm('Are you sure to resign this course?')"> Resign </a>
					                            </td>
					                        <tr>
					                    @endforeach
					                </tbody>
					            </table>
					        </div>
					        <a href="{{ url('class/add') }}/{{$class->id}}" class="btn btn-primary" role="button">Assign Course</a>
					    </div>
					</div>
			</div>
		</div>
	</div>
@endsection
