package com.example.sammy.record_lahan;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import java.util.ArrayList;

public class adapter extends RecyclerView.Adapter<adapter.MahasiswaViewHolder> {


    private ArrayList<model> dataList;

    public adapter(ArrayList<model> dataList) {
        this.dataList = dataList;
    }

    @Override
    public MahasiswaViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater layoutInflater = LayoutInflater.from(parent.getContext());
        View view = layoutInflater.inflate(R.layout.row, parent, false);
        return new MahasiswaViewHolder(view);
    }

    @Override
    public void onBindViewHolder(MahasiswaViewHolder holder, int position) {
        holder.jenis.setText(dataList.get(position).getJenis());
        holder.ukuran.setText(dataList.get(position).getUkuran());
        holder.jenisTanaman.setText(dataList.get(position).getJenisTanaman());
        holder.lokasi.setText(dataList.get(position).getLokasi());
        holder.nama.setText(dataList.get(position).getNama());
        holder.contact.setText(dataList.get(position).getContact());
    }

    @Override
    public int getItemCount() {
        return (dataList != null) ? dataList.size() : 0;
    }

    public class MahasiswaViewHolder extends RecyclerView.ViewHolder{
        private TextView jenis, ukuran, jenisTanaman,lokasi,nama,contact;

        public MahasiswaViewHolder(View itemView) {
            super(itemView);
            jenis=itemView.findViewById(R.id.txt_jenis);
            ukuran=itemView.findViewById(R.id.txt_ukuran);
            jenisTanaman=itemView.findViewById(R.id.txt_jenisTanaman);
            lokasi=itemView.findViewById(R.id.txt_lokasi);
            nama=itemView.findViewById(R.id.txt_nama);
            contact=itemView.findViewById(R.id.txt_contact);
        }
    }
}
