package com.example.sammy.record_lahan;

import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.ViewFlipper;
import android.content.BroadcastReceiver;

public class homeBefore extends AppCompatActivity {

    ViewFlipper v_flipper;
    DatabaseHelper dbcenter;
    Cursor cursor;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_home_before);

        int images[] = {R.drawable.pertanian, R.drawable.pertanian2, R.drawable.pertanian3};
        v_flipper = findViewById(R.id.v_flipper);

        for (int i = 0; i < images.length; i++) {
            fliverImages(images[i]);
        }
        for (int image : images)
            fliverImages(image);
    }


    public void onClickToLogin(View view) {
        Intent login = new Intent(homeBefore.this, com.example.sammy.record_lahan.login.class);
        startActivity(login);
        finish();
    }

    public void onClickToRegister(View view) {
        Intent register = new Intent(homeBefore.this, com.example.sammy.record_lahan.register.class);
        startActivity(register);
        finish();
    }

    public void fliverImages(int images) {
        ImageView imageView = new ImageView(this);
        imageView.setBackgroundResource(images);

        v_flipper.addView(imageView);
        v_flipper.setFlipInterval(4000);
        v_flipper.setAutoStart(true);

        v_flipper.setInAnimation(this, android.R.anim.slide_in_left);
        v_flipper.setOutAnimation(this, android.R.anim.slide_out_right);

    }

    @Override
    public void onBackPressed() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setCancelable(true);
        builder.setMessage("Do you want to Exit?");
        builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                //if user pressed "yes", then he is allowed to exit from application
                finish();
            }
        });
    }
}
