package com.example.sammy.record_lahan;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;

import com.example.sammy.record_lahan.api.HomestayController;
import com.example.sammy.record_lahan.api.homestayModel;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class utama extends AppCompatActivity {
    ListView grdData;
    private static final class Holder{
        public TextView nama_homestay;
        public TextView alamat;
        public TextView area, jumlah_kamar, harga, gambar;
    }
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_utama);
        grdData = (ListView) findViewById(R.id.grdData);

        HomestayController data = new HomestayController(this);
        try {
            data.open();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        data.getData();

        HomestayAdapter adapter= new HomestayAdapter(this, android.R.layout.simple_list_item_1, data.getData());
        grdData.setAdapter((ListAdapter) adapter);
        data.close();
    }

    private class HomestayAdapter extends ArrayAdapter<homestayModel> {
        private LayoutInflater minflater;
        public HomestayAdapter(@NonNull Context context, @LayoutRes int resource, @NonNull ArrayList<homestayModel> objects) {
            super(context, resource, objects);
            minflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        }
        public View getView(int position, View convertVIew, ViewGroup parent){
            View view = convertVIew;
            Holder holder;

            if(view == null){
                view = minflater.inflate(R.layout.custom_home,parent, false);
                holder = new Holder();
                holder.nama_homestay = (TextView) view.findViewById(R.id.tvTim1);
                holder.alamat = (TextView) view.findViewById(R.id.tvSkor);
                holder.area = (TextView) view.findViewById(R.id.tvTim2);
                holder.jumlah_kamar = (TextView) view.findViewById(R.id.jumlah_kamar);
                holder.harga = (TextView) view.findViewById(R.id.harga);
                holder.gambar = (TextView) view.findViewById(R.id.gambar);

                view.setTag(holder);
            }else{
                holder = (Holder) view.getTag();
            }
            homestayModel stream = getItem(position);
            holder.nama_homestay.setText(stream.getNama_homestay());
            holder.alamat.setText(stream.getAlamat());
            holder.area.setText(stream.getArea_terdekat());
            holder.jumlah_kamar.setText(stream.getJumlah_kamar());
            holder.harga.setText(stream.getHarga());
            holder.gambar.setText(stream.getGambar());
            return view;
        }
    }
}
