<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Client;

class ClientController extends Controller
{
    public function index(){
    	$search = \Request::get('search');
        $data = Client::where('fullnames','like','%'.$search.'%')->orderBy('id')->paginate(6);
        //$data = Client::All();
    	return view('client.daftar_client')->with('data',$data);
    }

    public function create(){
    	return view('client.buat_client');
    }

    public function store(Request $request){
    	$this->validate($request,[
            'image'=>'required',
            'fullnames'=>'required',
            'sex'=>'required',
            'birthdate'=>'required',
            'idcard'=>'required',
            'province'=>'required',
            'district'=>'required',
            'sector'=>'required',
            ]);
        $client = new client;
        $client->image = $request->image;
        $client->fullnames = $request->fullnames;
        $client->sex = $request->sex;
        $client->birthdate = $request->birthdate;
        $client->idcard = $request->idcard;
        $client->province = $request->province;
        $client->district = $request->district;
        $client->sector = $request->sector;
        $client->save();
        return redirect()->route('client.index')->with('alert-success','Data has been Saved!');
    }

    public function edit($id){
  	$data = Client::findorfail($id);
  	return view('client.edit_client')->with('data',$data);
    }

    public function show($name)
    {
        $client = Client::where('fullnames', 'LIKE', '%'.$name.'')->get();
         return view('client.daftar_client',compact('client'));

    }

  public function update(Request $request, $id){
        $this->validate($request,[
            'image'=>'required',
            'fullnames'=>'required',
            'sex'=>'required',
            'birthdate'=>'required',
            'idcard'=>'required',
            'province'=>'required',
            'district'=>'required',
            'sector'=>'required',
            ]);
        $client = Client::findorfail($id);
        $client->image = $request->image;
        $client->fullnames = $request->fullnames;
        $client->sex = $request->sex;
        $client->birthdate = $request->birthdate;
        $client->idcard = $request->idcard;
        $client->province = $request->province;
        $client->district = $request->district;
        $client->sector = $request->sector;
        $client->save(); 
    return redirect()->route('client.index')->with('alert-success','Data has been Saved!');  
    }

        public function destroy($id)
    {
        Client::find($id)->delete();
        return redirect('client');
    }

    public function search(Request $request, $fullnames)
    {
        $search = Input::get('fullnames');

        if ($search){

            $hasil = Client::find($fullnames);            
            $data = $hasil->where('fullnames', 'LIKE', '%'. $search .'%')->get();

            return view('client.daftar_client')->with('data', $data);                 
             }       
    }
}