!function ($) {
    "use strict";
    // version: 2.7
    // by Mattia Larentis - follow me on twitter! @SpiritualGuru

    var addToAttribute = function (obj, array, value) {
        var i = 0
            , length = array.length;

        for (; i < length; i++) {
            obj = obj[array[i]] = obj[array[i]] || i == ( length - 1) ? value : {}
        }
    };

    $.fn.toggleButtons = function (method) {
        var $element
            , $div
            , transitionSpeed = 0.05
            , methods = {
                init: function (opt) {
                    this.each(function () {
                            var $spanLeft
                                , $spanRight
                                , options
                                , moving
                                , dataAttribute = {};

                            $element = $(this);
                            $element.addClass('toggle-button');

                            $.each($element.data(), function (i, el) {
                                var key
                                    , tmp = {};

                                if (i.indexOf("togglebutton") === 0) {
                                    key = i.match(/[A-Z][a-z]+/g);
                                    key = $.map(key, function (n) {
                                        return (n.toLowerCase());
                                    });

                                    addToAttribute(tmp, key, el);
                                    dataAttribute = $.extend(true, dataAttribute, tmp);
                                }
                            });

                            options = $.extend(true, {}, $.fn.toggleButtons.defaults, opt, dataAttribute);

                            $(this).data('options', options);

                            $spanLeft = $('<span></span>').addClass("labelLeft").text(options.label.enabled === undefined ? "ON" : options.label.enabled);
                            $spanRight = $('<span></span>').addClass("labelRight").text(options.label.disabled === undefined ? "OFF " : options.label.disabled);

                            // html layout
                            $div = $element.find('input:checkbox').wrap($('<div></div>')).parent();
                            $div.append($spanLeft);
                            $div.append($('<label></label>').attr('for', $element.find('input').attr('id')));
                            $div.append($spanRight);

                            if ($element.find('input').is(':checked'))
                                $element.find('>div').css('left', "0");
                            else $element.find('>div').css('left', "-50%");

                            if (options.animated) {
                                if (options.transitionspeed !== undefined)
                                    if (/^(\d*%$)/.test(options.transitionspeed))  // is a percent value?
                                        transitionSpeed = 0.05 * parseInt(options.transitionspeed) / 100;
                                    else
                                        transitionSpeed = options.transitionspeed;
                            }
                            else transitionSpeed = 0;

                            $(this).data('transitionSpeed', transitionSpeed * 1000);


                            options["width"] /= 2;

                            // width of the bootstrap-toggle-button
                            $element
                                .css('width', options.width * 2)
                                .find('>div').css('width', options.width * 3)
                                .find('>span, >label').css('width', options.width);

                            // height of the bootstrap-toggle-button
                            $element
                                .css('height', options.height)
                                .find('span, label')
                                .css('height', options.height)
                                .filter('span')
                                .css('line-height', options.height + "px");

                            if ($element.find('input').is(':disabled'))
                                $(this).addClass('deactivate');

                            $element.find('span').css(options.font);


                            // enabled custom color
                            if (options.style.enabled === undefined) {
                                if (options.style.custom !== undefined && options.style.custom.enabled !== undefined && options.style.custom.enabled.background !== undefined) {
                                    $spanLeft.css('color', options.style.custom.enabled.color);
                                    if (options.style.custom.enabled.gradient === undefined)
                                        $spanLeft.css('background', options.style.custom.enabled.background);
                                    else $.each(["-webkit-", "-moz-", "-o-", ""], function (i, el) {
                                        $spanLeft.css('background-image', el + 'linear-gradient(top, ' + options.style.custom.enabled.background + ',' + options.style.custom.enabled.gradient + ')');
                                    });
                                }
                            }
                            else $spanLeft.addClass(options.style.enabled);

                            // disabled custom color
                            if (options.style.disabled === undefined) {
                                if (options.style.custom !== undefined && options.style.custom.disabled !== undefined && options.style.custom.disabled.background !== undefined) {
                                    $spanRight.css('color', options.style.custom.disabled.color);
                                    if (options.style.custom.disabled.gradient === undefined)
                                        $spanRight.css('background', options.style.custom.disabled.background);
                                    else $.each(["-webkit-", "-moz-", "-o-", ""], function (i, el) {
                                        $spanRight.css('background-image', el + 'linear-gradient(top, ' + options.style.custom.disabled.background + ',' + options.style.custom.disabled.gradient + ')');
                                    });
                                }
                            }
                            else $spanRight.addClass(options.style.disabled);

                            var changeStatus = function ($this) {
                                $this.siblings('label')
                                    .trigger('mousedown')
                                    .trigger('mouseup')
                                    .trigger('click');
                            };

                            $spanLeft.on('click', function (e) {
                                changeStatus($(this));
                            });
                            $spanRight.on('click', function (e) {
                                changeStatus($(this));
                            });

                            $('.toggle-button').find('input').on('change', function (e, skipOnChange) {
                                var $element = $(this).parent()
                                    , active = $(this).is(':checked')
                                    , $toggleButton = $(this).closest('.toggle-button');

                                e.preventDefault();
                                e.stopImmediatePropagation();

                                $element.stop().animate({'left': active ? '0' : '-50%'}, $toggleButton.data('transitionSpeed'));

                                options = $toggleButton.data('options');

                                if (!skipOnChange)
                                    options.onChange($element, active, e);
                            });

                            $('.toggle-button').find('label').on('mousedown touchstart', function (e) {
                                moving = false;
                                e.preventDefault();
                                e.stopImmediatePropagation();

                                if ($(this).closest('.toggle-button').is('.deactivate'))
                                    $(this).off('click');
                                else {
                                    $(this).on('mousemove touchmove', function (e) {
                                        var $element = $(this).closest('.toggle-button')
                                            , relativeX = (e.pageX || e.originalEvent.targetTouches[0].pageX) - $element.offset().left
                                            , percent = ((relativeX / (options.width * 2)) * 100);
                                        moving = true;

                                        e.stopImmediatePropagation();
                                        e.preventDefault();

                                        if (percent < 25)
                                            percent = 25;
                                        else if (percent > 75)
                                            percent = 75;

                                        $element.find('>div').css('left', (percent - 75) + "%");
                                    });

                                    $(this).on('click touchend', function (e) {
                                        var $target = $(e.target)
                                            , $myCheckBox = $target.siblings('input');

                                        e.stopImmediatePropagation();
                                        e.preventDefault();
                                        $(this).off('mouseleave');

                                        if (moving)
                                            if (parseInt($(this).parent().css('left')) < -25)
                                                $myCheckBox.attr('checked', false);
                                            else $myCheckBox.attr('checked', true);
                                        else $myCheckBox.attr("checked", !$myCheckBox.is(":checked"));

                                        $myCheckBox.trigger('change');
                                    });

                                    $(this).on('mouseleave', function (e) {
                                        var $myCheckBox = $(this).siblings('input');

                                        e.preventDefault();
                                        e.stopImmediatePropagation();

                                        $(this).off('mouseleave');
                                        $(this).trigger('mouseup');

                                        if (parseInt($(this).parent().css('left')) < -25)
                                            $myCheckBox.attr('checked', false);
                                        else $myCheckBox.attr('checked', true);

                                        $myCheckBox.trigger('change');
                                    });

                                    $(this).on('mouseup', function (e) {
                                        e.stopImmediatePropagation();
                                        e.preventDefault();
                                        $(this).off('mousemove');
                                    });
                                }
                            });
                        }
                    );
                    return this;
                },
                toggleActivation: function () {
                    $(this).toggleClass('deactivate');
                },
                toggleState: function (skipOnChange) {
                    var $input = $(this).find('input');
                    $input.attr('checked', !$input.is(':checked')).trigger('change', skipOnChange);
                },
                setState: function(value, skipOnChange) {
                    $(this).find('input').attr('checked', value).trigger('change', skipOnChange);
                }
            };

        if (methods[method])
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        else if (typeof method === 'object' || !method)
            return methods.init.apply(this, arguments);
        else
            $.error('Method ' + method + ' does not exist!');
    };

    $.fn.toggleButtons.defaults = {
        onChange: function () {
        },
        width: 100,
        height: 25,
        font: {},
        animated: true,
        transitionspeed: undefined,
        label: {
            enabled: undefined,
            disabled: undefined
        },
        style: {
            enabled: undefined,
            disabled: undefined,
            custom: {
                enabled: {
                    background: undefined,
                    gradient: undefined,
                    color: "#FFFFFF"
                },
                disabled: {
                    background: undefined,
                    gradient: undefined,
                    color: "#FFFFFF"
                }
            }
        }
    };
}(jQuery);