/*
SQLyog Ultimate v9.51 
MySQL - 5.5.27 : Database - pidel_hr
*********************************************************************
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`pidel_hr` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `pidel_hr`;

/*Table structure for table `hrd_d_pegawai` */

DROP TABLE IF EXISTS `hrd_d_pegawai`;

CREATE TABLE `hrd_d_pegawai` (
  `pegawaidetail_id` int(11) NOT NULL AUTO_INCREMENT,
  `nip` varchar(45) DEFAULT NULL,
  `no_ktp` varchar(45) DEFAULT NULL,
  `d_akhir_ktp` date DEFAULT NULL,
  `alamat_ktp` varchar(255) DEFAULT NULL,
  `no_hp` varchar(20) DEFAULT NULL,
  `no_tlp_rumah` varchar(20) DEFAULT NULL,
  `created_by` varchar(200) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `created_ip` varchar(15) DEFAULT NULL,
  `updated_by` varchar(200) DEFAULT NULL,
  `updated_date` datetime DEFAULT NULL,
  `updated_ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`pegawaidetail_id`),
  KEY `FK_hrd_d_pegawai` (`nip`),
  CONSTRAINT `FK_hrd_d_pegawai` FOREIGN KEY (`nip`) REFERENCES `hrd_m_pegawai` (`nip`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

/*Data for the table `hrd_d_pegawai` */

insert  into `hrd_d_pegawai`(`pegawaidetail_id`,`nip`,`no_ktp`,`d_akhir_ktp`,`alamat_ktp`,`no_hp`,`no_tlp_rumah`,`created_by`,`created_date`,`created_ip`,`updated_by`,`updated_date`,`updated_ip`) values (2,'9999999','8765432','2014-08-19','Testing','9876543','8765432','76','2014-08-18 09:18:00','127.0.0.1',NULL,NULL,NULL),(3,'8888888','6666666','2014-08-18','Blank','987654321','987654321','76','2014-08-18 10:27:24','127.0.0.1',NULL,NULL,NULL);

/*Table structure for table `hrd_d_request_duty_letter` */

DROP TABLE IF EXISTS `hrd_d_request_duty_letter`;

CREATE TABLE `hrd_d_request_duty_letter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_hrd_t_request_duty_letter` int(11) NOT NULL,
  `nama_petugas` varchar(100) NOT NULL,
  `nama_pengemban_tugas` varchar(100) NOT NULL,
  `keterangan` text NOT NULL,
  `created_by` varchar(15) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `created_ip` varchar(200) DEFAULT NULL,
  `updated_by` varchar(15) DEFAULT NULL,
  `updated_date` datetime DEFAULT NULL,
  `updated_ip` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_d_request_t_request` (`id_hrd_t_request_duty_letter`),
  CONSTRAINT `fk_d_request_t_request` FOREIGN KEY (`id_hrd_t_request_duty_letter`) REFERENCES `hrd_t_request_duty_letter` (`rdl_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `hrd_d_request_duty_letter` */

/*Table structure for table `hrd_h_request_duty_letter` */

DROP TABLE IF EXISTS `hrd_h_request_duty_letter`;

CREATE TABLE `hrd_h_request_duty_letter` (
  `rdl_history_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id history',
  `request_id` int(11) NOT NULL COMMENT 'id request',
  `status_id` int(11) NOT NULL COMMENT 'status request',
  `created_by` varchar(255) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `created_ip` varchar(15) DEFAULT NULL,
  `updated_by` varchar(255) DEFAULT NULL,
  `updated_date` datetime DEFAULT NULL,
  `updated_ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`rdl_history_id`),
  KEY `request_id` (`request_id`),
  KEY `status_id` (`status_id`),
  CONSTRAINT `FK_hrd_h_request_duty_letter` FOREIGN KEY (`status_id`) REFERENCES `hrd_r_status` (`status_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_hrd_h_request_duty_letter_id` FOREIGN KEY (`request_id`) REFERENCES `hrd_t_request_duty_letter` (`rdl_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `hrd_h_request_duty_letter` */

/*Table structure for table `hrd_h_riwayat_pendidikan` */

DROP TABLE IF EXISTS `hrd_h_riwayat_pendidikan`;

CREATE TABLE `hrd_h_riwayat_pendidikan` (
  `pendidikan_id` int(11) NOT NULL AUTO_INCREMENT,
  `nidn` int(11) NOT NULL,
  `perguruan_tinggi` varchar(200) DEFAULT NULL,
  `gelar_akademik` varchar(10) DEFAULT NULL,
  `t_ijazah` date DEFAULT NULL,
  `jenjang` char(5) DEFAULT NULL,
  `created_by` varchar(15) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `created_ip` varchar(200) DEFAULT NULL,
  `updated_by` varchar(15) DEFAULT NULL,
  `updated_date` datetime DEFAULT NULL,
  `updated_ip` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`pendidikan_id`),
  KEY `FK_hrd_h_riwayat_pendidikan` (`nidn`),
  CONSTRAINT `FK_hrd_h_riwayat_pendidikan` FOREIGN KEY (`nidn`) REFERENCES `hrd_m_dosen` (`nidn`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

/*Data for the table `hrd_h_riwayat_pendidikan` */

insert  into `hrd_h_riwayat_pendidikan`(`pendidikan_id`,`nidn`,`perguruan_tinggi`,`gelar_akademik`,`t_ijazah`,`jenjang`,`created_by`,`created_date`,`created_ip`,`updated_by`,`updated_date`,`updated_ip`) values (1,99999,'USU','M.T.','2014-08-01','S2','76','2014-08-18 09:31:37','127.0.0.1',NULL,NULL,NULL),(3,777777,'Belanda','M.ISD','2014-08-18','S2','76','2014-08-18 12:06:25','127.0.0.1',NULL,NULL,NULL);

/*Table structure for table `hrd_h_riwayat_pengajaran` */

DROP TABLE IF EXISTS `hrd_h_riwayat_pengajaran`;

CREATE TABLE `hrd_h_riwayat_pengajaran` (
  `pengajaran_id` int(11) NOT NULL AUTO_INCREMENT,
  `nidn` int(11) DEFAULT NULL,
  `semester` smallint(2) DEFAULT NULL,
  `kode_mk` char(10) DEFAULT NULL,
  `nama_mk` varchar(200) DEFAULT NULL,
  `kode_kelas` varchar(5) DEFAULT NULL,
  `created_by` varchar(15) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `created_ip` varchar(200) DEFAULT NULL,
  `updated_by` varchar(15) DEFAULT NULL,
  `updated_date` datetime DEFAULT NULL,
  `updated_ip` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`pengajaran_id`),
  KEY `FK_hrd_h_riwayat_pengajaran` (`nidn`),
  CONSTRAINT `FK_hrd_h_riwayat_pengajaran` FOREIGN KEY (`nidn`) REFERENCES `hrd_m_dosen` (`nidn`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `hrd_h_riwayat_pengajaran` */

/*Table structure for table `hrd_m_dosen` */

DROP TABLE IF EXISTS `hrd_m_dosen`;

CREATE TABLE `hrd_m_dosen` (
  `nidn` int(11) NOT NULL,
  `nip` varchar(45) DEFAULT NULL,
  `pend_akhir` varchar(200) DEFAULT NULL,
  `prodi` varchar(45) DEFAULT NULL COMMENT 'Program Studi',
  `gbk_1` varchar(50) DEFAULT NULL,
  `gbk_2` varchar(50) DEFAULT NULL,
  `created_by` varchar(15) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `created_ip` varchar(200) DEFAULT NULL,
  `updated_by` varchar(15) DEFAULT NULL,
  `updated_date` datetime DEFAULT NULL,
  `updated_ip` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`nidn`),
  KEY `FK_hrd_m_dosen` (`nip`),
  CONSTRAINT `FK_hrd_m_dosen` FOREIGN KEY (`nip`) REFERENCES `hrd_m_pegawai` (`nip`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `hrd_m_dosen` */

insert  into `hrd_m_dosen`(`nidn`,`nip`,`pend_akhir`,`prodi`,`gbk_1`,`gbk_2`,`created_by`,`created_date`,`created_ip`,`updated_by`,`updated_date`,`updated_ip`) values (99999,'10117613080101','M.Sc','Teknik Informatika','DAME','THIN','76','2014-08-18 09:03:47','127.0.0.1',NULL,NULL,NULL),(777777,'24108220030701','S2','Sistem Informasi','Dame','Thin','76','2014-08-18 12:05:29','127.0.0.1',NULL,NULL,NULL),(5555555,'270280190913','M.T','Teknik Informatika','Prosede','Dame','76','2014-08-18 09:20:07','127.0.0.1',NULL,NULL,NULL);

/*Table structure for table `hrd_m_duty_letter` */

DROP TABLE IF EXISTS `hrd_m_duty_letter`;

CREATE TABLE `hrd_m_duty_letter` (
  `duty_letter_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id surat tugas',
  `request_id` int(11) NOT NULL COMMENT 'id request surat tugas',
  `duty_letter_number` varchar(50) NOT NULL COMMENT 'nomor surat tugas',
  `duty_letter_date` date NOT NULL COMMENT 'tanggal surat tugas',
  `signed_by` int(10) NOT NULL COMMENT 'pejabat yang menandatangani',
  `depart_transport` varchar(50) NOT NULL COMMENT 'transportasi berangkat',
  `return_transport` varchar(50) NOT NULL COMMENT 'transportasi kembali',
  `route_journey` varchar(200) NOT NULL COMMENT 'rute perjalanan',
  `hostelry` varchar(200) NOT NULL COMMENT 'penginapan yang digunakan',
  `sppd_duration` int(10) NOT NULL COMMENT 'durasi sppd yang dikenakan',
  `status_id` int(11) NOT NULL COMMENT 'status surat tugas (reported / not reported yet)',
  `task_shifting` text NOT NULL COMMENT 'pengalihan surat tugas',
  `created_by` varchar(100) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `created_ip` varchar(15) DEFAULT NULL,
  `updated_by` varchar(100) DEFAULT NULL,
  `updated_date` datetime DEFAULT NULL,
  `updated_ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`duty_letter_id`),
  KEY `duty_letter_status` (`status_id`,`request_id`),
  KEY `request_id` (`request_id`),
  KEY `signed_by` (`signed_by`),
  CONSTRAINT `FK_hrd_m_duty_letter` FOREIGN KEY (`status_id`) REFERENCES `hrd_r_status` (`status_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_hrd_m_duty_letter_request` FOREIGN KEY (`request_id`) REFERENCES `hrd_t_request_duty_letter` (`rdl_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `hrd_m_duty_letter` */

/*Table structure for table `hrd_m_pegawai` */

DROP TABLE IF EXISTS `hrd_m_pegawai`;

CREATE TABLE `hrd_m_pegawai` (
  `nip` varchar(45) NOT NULL,
  `nama` varchar(200) NOT NULL,
  `alias` varchar(15) NOT NULL,
  `jenis_kelamin` enum('Laki-laki','Perempuan') NOT NULL COMMENT 'Jenis Kelamin',
  `tempat_lahir` varchar(200) NOT NULL,
  `t_lahir` date NOT NULL,
  `status_kawin` enum('TK','K-0','K-1','K-2','K-3','K-4','K-5','K-6') NOT NULL,
  `d_awal_kerja` date NOT NULL,
  `grup_awal` varchar(100) NOT NULL,
  `grup_now` varchar(100) NOT NULL,
  `status_now` enum('Aktif','TSDP','Keluar','Meninggal') NOT NULL COMMENT 'Status Aktivitas',
  `unit_kerja` enum('IT Del','Yacab','Yapus') NOT NULL,
  `ukuran_baju` enum('S','M','L','XL','XXL') NOT NULL,
  `status_kepeg` enum('Tetap','Kontrak','Harian') NOT NULL COMMENT 'Status Ikatan Kerja',
  `user_id` int(10) DEFAULT NULL,
  `pendidikan_awal` enum('SMP','SMA','SMK','D1','D2','D3','S1','S2','S3') NOT NULL,
  `pendidikan_now` enum('SMP','SMA','SMK','D1','D2','D3','S1','S2','S3') NOT NULL COMMENT 'Pendidikan Tertinggi',
  `golongan_awal` varchar(45) DEFAULT NULL,
  `prefix_gelar` varchar(45) DEFAULT NULL,
  `suffix_gelar` varchar(45) DEFAULT NULL,
  `golongan_now` varchar(45) DEFAULT NULL,
  `created_by` varchar(200) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `created_ip` varchar(15) DEFAULT NULL,
  `updated_by` varchar(200) DEFAULT NULL,
  `updated_date` datetime DEFAULT NULL,
  `updated_ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`nip`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `hrd_m_pegawai` */

insert  into `hrd_m_pegawai`(`nip`,`nama`,`alias`,`jenis_kelamin`,`tempat_lahir`,`t_lahir`,`status_kawin`,`d_awal_kerja`,`grup_awal`,`grup_now`,`status_now`,`unit_kerja`,`ukuran_baju`,`status_kepeg`,`user_id`,`pendidikan_awal`,`pendidikan_now`,`golongan_awal`,`prefix_gelar`,`suffix_gelar`,`golongan_now`,`created_by`,`created_date`,`created_ip`,`updated_by`,`updated_date`,`updated_ip`) values ('01017406100801','Marnalom Pangaribuan','MP','Laki-laki','Pematangsiantar','1974-01-01','K-2','2008-10-06','Taman','Taman','Keluar','Yacab','S','Kontrak',NULL,'SMP','SMP','','','','','arya','2011-02-18 23:32:20','172.21.3.86','fidelis','2012-03-07 09:01:57','172.21.3.76'),('01029128080901','Rio Patar Siregar','','Laki-laki','','1991-02-01','TK','2009-08-28','CS','Maintenance','Aktif','Yacab','','Kontrak',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:25:25','172.21.3.86','gerry','2012-10-19 15:02:39','172.21.1.33'),('01059005091101','Edwin Swandi Sijabat','Edwin','Laki-laki','Laras Dua','1990-05-01','TK','2011-09-05','Ass Dosen','Ass Dosen','Aktif','IT Del','','Tetap',NULL,'D3','S1','Asisten Dosen','A.Md','A.Md','Asisten Dosen','fidelis','2012-02-29 08:57:30','172.21.3.76','fidelis','2014-07-02 14:25:19','172.21.2.2'),('01068505071101','Windy Nurani','Windy','Perempuan','Bandung','1985-06-01','TK','2011-07-05','Pustakawan','Pustakawan','Keluar','IT Del','S','Harian',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'fidelis','2012-03-08 10:48:13','172.21.3.76',NULL,NULL,NULL),('01098301031201','Lasma Ida Tambunan','Lasma','Perempuan','Balige','1983-09-01','TK','2012-03-01','Staf','Staf','Aktif','Yacab','M','Harian',NULL,'S1','S1',NULL,NULL,NULL,NULL,'gerry','2012-10-19 16:20:07','172.21.1.33',NULL,NULL,NULL),('02088801071301','Topo Udra Napitupulu','Topo','Laki-laki','Pekanbaru','1988-08-02','TK','2013-07-01','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Keluar','IT Del','L','Kontrak',NULL,'D3','D3','asisten bapak/ibu asrama',NULL,NULL,'asisten bapak/ibu asrama','fidelis','2013-07-11 10:40:18','172.21.2.47','fidelis','2014-07-02 14:32:51','172.21.2.2'),('02098612091101','Efi Shanty Fransiska Panjaitan','Efi','Perempuan','Pematang Siantar','1986-09-02','TK','2011-09-12','Ass Dosen','Ass Dosen','Keluar','IT Del','S','Harian',NULL,'S1','S1',NULL,NULL,'S.Pd',NULL,'fidelis','2012-03-08 10:40:30','172.21.3.76',NULL,NULL,NULL),('02128705071201','Cori Sarma Natalia Lumban Gaol, SS','Lia','Perempuan','Kembang Seri','1987-12-01','TK','2012-07-05','Ass Dosen','Ass Dosen','Aktif','IT Del','M','Tetap',0,'S1','S1','asisten dosen merangkap guru PAUD','','SS','Staf SDM','fidelis','2012-07-09 10:10:21','172.21.3.76','fidelis','2014-07-02 14:29:29','172.21.2.2'),('02129029081301','Ardo H Steven Nainggolan','Ardo','Laki-laki','Pematangsiantar','1990-12-02','TK','2013-08-29','Staf','Staf','Aktif','IT Del','XXL','Kontrak',NULL,'D3','D3','Staf',NULL,'A.Md','Staf','fidelis','2013-09-11 16:18:08','172.21.6.11',NULL,NULL,NULL),('0301140096','Lit Malem Ginting, S.Si, MT','Lit ','Laki-laki','Medan','1978-09-18','K-1','2014-01-07','Dosen','Dosen','Aktif','IT Del','M','Kontrak',0,'S2','S2','Dosen','S.Si','MT','Dosen','fidelis','2014-07-02 14:56:16','172.21.2.2',NULL,NULL,NULL),('0301140097','Togar  Mangihut Simatupang','Togar','Laki-laki','Pematangsiantar','1968-12-31','K-3','2014-01-01','Dosen','Dosen','Aktif','IT Del','XL','Kontrak',NULL,'S3','S3','Dosen','Prof','Phd','Dosen','fidelis','2014-07-02 15:03:30','172.21.2.2',NULL,NULL,NULL),('0301140098','Adelina Manurung','Adelina','Perempuan','Laguboti','1983-03-05','K-0','2014-01-15','Dosen','Dosen','Aktif','IT Del','S','Kontrak',0,'S2','S2','Dosen','S.Si','M.Sc','Dosen','fidelis','2014-07-02 15:07:43','172.21.2.2',NULL,NULL,NULL),('0301140099','Ade Candra Simamora','Adelina','Laki-laki','Doloksanggul','1990-01-26','TK','2014-01-20','Ass Dosen','Ass Dosen','Aktif','IT Del','M','Kontrak',0,'D3','D3','Asisten Dosen','A.Md','A.Md','Asisten Dosen','fidelis','2014-07-02 15:47:16','172.21.2.2',NULL,NULL,NULL),('0301140100','Roga  Florida Kembaren,','Roga','Perempuan','Kabanjahe','1966-01-06','TK','2014-01-20','Dosen','Dosen','Aktif','IT Del','M','Kontrak',NULL,'S2','S2','Dosen','M.Sc','M.Sc','Dosen','fidelis','2014-07-03 14:33:46','172.21.2.2',NULL,NULL,NULL),('0301140101',' Merry Meryam Matgrita','Merry','Perempuan','Bandung','1970-03-12','TK','2014-01-20','Dosen','Dosen','Aktif','IT Del','M','Kontrak',NULL,'S3','S3','Dosen','S.Si','Dr','Dosen','fidelis','2014-07-03 14:37:25','172.21.2.2',NULL,NULL,NULL),('0301140102','Paulus Prananto','Paulus','Laki-laki','Tegal','1947-03-27','K-3','2014-01-20','Dosen','Dosen','Aktif','IT Del','XL','Kontrak',NULL,'S3','S3','Dosen','MSc','Dr.','Dosen','fidelis','2014-07-03 14:40:27','172.21.2.2',NULL,NULL,NULL),('030114H017','Sri Hermianti Panjaitan','Sri','Perempuan','Medan','1991-08-30','TK','2014-01-06','Suster Klinik','Suster Klinik','Aktif','IT Del','S','Harian',NULL,'D3','D3','Suster Klinik',NULL,NULL,'Suster klinik','fidelis','2014-07-02 15:43:18','172.21.2.2',NULL,NULL,NULL),('030114H018','Chrisman Tohonan Pangaribuan','Chrisman','Laki-laki','Pematangsiantar','1991-12-24','TK','2014-01-20','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Aktif','IT Del','M','Harian',NULL,'SMA','SMA','Asisten bapak asrama','',NULL,'Asisten bapak asrama','fidelis','2014-07-03 14:45:04','172.21.2.2',NULL,NULL,NULL),('030214H019','Harry Eliakim Hutagalung','Harry','Laki-laki','Sibolga','1991-05-01','TK','2014-02-21','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Aktif','IT Del','M','Harian',NULL,'SMA','SMA','Asisten bapak asrama','',NULL,'Asisten bapak asrama','fidelis','2014-07-03 14:49:19','172.21.2.2',NULL,NULL,NULL),('03039205101201','Santi Munthe','Santi','Perempuan','Hutatua','1992-03-03','TK','2012-10-05','Staf','Staf','Aktif','IT Del','S','Kontrak',0,'D1','D1',NULL,NULL,'A.P','Staf','fidelis','2012-10-12 11:55:16','172.21.2.253',NULL,NULL,NULL),('0304140104','Rintha Meylisa Gulo','Rintha','Perempuan','Batangserangan','1990-05-17','TK','2014-04-01','Staf','Staf','Aktif','IT Del','M','Kontrak',0,'','','Staf keuangan',NULL,'S.E','Staf keunagan','fidelis','2014-07-03 14:57:23','172.21.2.2',NULL,NULL,NULL),('0304140105','Alamta Singarimbun','Alamta','Laki-laki','Tiga Nderket','1960-02-21','K-2','0000-00-00','Dosen','Dosen','Aktif','IT Del','L','Kontrak',NULL,'SMP','','Dosen',NULL,NULL,'Dosen','fidelis','2014-07-03 15:00:18','172.21.2.2',NULL,NULL,NULL),('0304140106','Freddy Haryanto','Freddy','Laki-laki','Indramayu','1972-07-14','K-3','2014-04-01','Dosen','Dosen','Aktif','IT Del','M','Kontrak',NULL,'','','dosen','','Dr','Dosen','fidelis','2014-07-03 15:03:20','172.21.2.2',NULL,NULL,NULL),('0304140107','Ricardo Chandra Situmeang','Ricardo','Laki-laki','Medan','0000-00-00','','1981-02-21','Dosen','Dosen','Aktif','IT Del','M','Kontrak',0,'S2','S2','Dosen','S.PSi','M.Sc','Dosen','fidelis','2014-07-03 15:06:09','172.21.2.2',NULL,NULL,NULL),('0305140109','Vita Sani Adelina Hutapea','Vita','Perempuan','Pematangisantar','1992-01-14','TK','2014-05-05','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Aktif','IT Del','S','Kontrak',NULL,'S1','S1','Asisten bapak/ibu asrama',NULL,NULL,'Asisten bapak/ibu asrama','fidelis','2014-07-03 15:13:31','172.21.2.2',NULL,NULL,NULL),('0306140110','Lusiana Parhusip','Lusi','Perempuan','Nainggolan','1987-10-08','K-1','2014-06-10','Ass Dosen','Ass Dosen','Aktif','IT Del','S','Kontrak',0,'D3','D3','asisten dosen','A.Md','A.Md','Asisten dosen','fidelis','2014-07-03 15:16:36','172.21.2.2',NULL,NULL,NULL),('03089001071303','Lisda Gunawati Sirait','Lisda','Perempuan','Porsea','1990-08-03','TK','2013-07-01','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Keluar','IT Del','S','Kontrak',NULL,'S1','S1','asisten Bapak/ibu asrama','','S.Th','Asisten bapak/ibu asrama','fidelis','2013-07-11 10:37:41','172.21.2.47','fidelis','2014-07-02 14:32:01','172.21.2.2'),('03108501031201','Kristina Gloria Simanjuntak','KGS','Perempuan','Medan','1985-10-03','TK','2012-03-01','Dosen','Dosen','Keluar','IT Del','S','Tetap',0,'S1','S1',NULL,NULL,'S.Sos',NULL,'fidelis','2012-03-08 10:18:36','172.21.3.76','fidelis','2013-07-02 11:27:14','172.21.2.47'),('0331067503','Rymelda Susan Naiborhu','','Perempuan','','0000-00-00','TK','2003-11-02','Staf','Staf','Aktif','Yacab','','Tetap',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:47:09','172.21.3.86','good','2011-04-27 15:24:28','172.23.2.145'),('04024018070101','Partumpuan Naiborhu','','Laki-laki','','1940-02-04','K-0','0000-00-00','Ketua Yayasan Cabang','Ketua Yayasan Cabang','Aktif','Yacab','XL','Tetap',NULL,'S2','S2',NULL,NULL,NULL,NULL,'arya','2011-02-18 21:19:49','172.21.3.86','fidelis','2012-03-07 09:51:51','172.21.3.76'),('04027701051201','Albert Sagala','ABS','Laki-laki','Samosir','1977-02-04','K-2','2012-05-01','Dosen','Dosen','Aktif','IT Del','L','Tetap',0,'S2','S2','Dosen',NULL,'MT','Dosen','fidelis','2012-05-01 14:49:20','172.21.3.76','fidelis','2013-01-18 17:06:22','172.21.2.4'),('04029020091001','Eko A. Silitonga','EKO','Laki-laki','','1990-02-04','TK','2010-09-20','Duktek','Ass Dosen','Keluar','IT Del','','Tetap',NULL,'D3','D3',NULL,NULL,'Amd.',NULL,'good','2011-04-01 13:27:08','172.23.2.145','fidelis','2014-07-02 14:23:16','172.21.2.2'),('05018529090901','Ecko Fernando Basarah Manalu','EFM','Laki-laki','','1985-01-05','TK','2009-09-09','Ass Dosen','Ass Dosen','Keluar','IT Del','','Tetap',NULL,'D3','D3','II/D',NULL,'A.Md.','II/D','good','2011-04-01 13:57:56','172.23.2.145','fidelis','2013-01-18 17:12:35','172.21.2.4'),('05025708041201','Rakam Gurning','GURNING','Laki-laki','Ajibata','1957-02-05','K-0','2012-04-08','Satpam','Satpam','Aktif','Yacab','M','Kontrak',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'gerry','2012-10-19 15:54:31','172.21.1.33','gerry','2012-10-19 16:01:47','172.21.1.33'),('05051001118701','Nova Yanti Lumban Gaol','Nova','','Narumonda','1987-11-01','TK','2010-05-05','Suster Klinik','Suster Klinik','Aktif','IT Del','S','Harian',0,'D3','D3','suster klinik','','A.Md','Suster klinik','fidelis','2012-05-07 07:58:00','172.21.3.76','togu','2012-07-10 15:26:19','172.21.2.161'),('05076501110301','Ramli Pasaribu','','Laki-laki','Garoga','1965-07-05','K-0','2003-11-01','Taman','Taman','Aktif','Yacab','L','Kontrak',NULL,'SMP','SMP',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:30:23','172.21.3.86','good','2011-04-27 15:16:10','172.23.2.145'),('05088317091301','Santi Agustina Manalu','Santi','Perempuan','Tarutung','1983-08-05','TK','2013-09-17','Dosen','Dosen','Aktif','IT Del','S','Kontrak',0,'S2','S2','Dosen',NULL,'M.Pd','Dosen','fidelis','2013-09-19 11:07:36','172.21.6.11',NULL,NULL,NULL),('05128501071101','Yonathan Kristiono Gunadi','Kris','Laki-laki','Surabaya','1985-12-05','TK','2011-07-01','Dokter Kampus','Dokter Kampus','Keluar','IT Del','L','Kontrak',NULL,'S1','S1',NULL,'dr','',NULL,'fidelis','2012-03-08 11:00:19','172.21.3.76','fidelis','2013-07-02 11:28:05','172.21.2.47'),('06037501040501','Timur Siagian','','Laki-laki','','1975-03-06','K-2','2005-04-01','Pengemudi','Pengemudi','Aktif','Yacab','','Kontrak',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:37:38','172.21.3.86','gerry','2012-10-19 15:05:25','172.21.1.33'),('06068920091001','Genesis SG. Banjarnahor, AMd','GEN','Laki-laki','','1989-06-06','TK','2010-09-20','Duktek','Ass Dosen','Keluar','IT Del','','Tetap',NULL,'D3','D3','II/D',NULL,'Amd.',NULL,'good','2011-04-01 13:28:48','172.23.2.145','fidelis','2013-03-13 13:44:10','172.21.2.4'),('06077502020901','Pangaluan Hutagaol','','Laki-laki','','1975-07-06','K-3','2009-02-02','CS','CS','Aktif','IT Del','','Kontrak',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:20:53','172.21.3.86','good','2011-04-27 15:12:02','172.23.2.145'),('06078116021101','Fauzan','Fauzan','Laki-laki','Bandung','1981-07-06','TK','2011-02-16','Staf','Staf','Keluar','IT Del','','Kontrak',NULL,'D3','D3',NULL,NULL,'Amd.',NULL,'good','2011-04-01 12:40:35','172.23.2.145','fidelis','2012-03-07 09:06:02','172.21.3.76'),('06078401071001','Eva Tudi Risbek Hotmarina Sianga','Eva','Perempuan','','1984-07-06','K-0','2010-07-01','Bapak/Ibu Asrama','Bapak/Ibu Asrama','Keluar','IT Del','','Kontrak',NULL,'S1','S1',NULL,'Pdt. ','STh',NULL,'arya','2011-02-18 23:47:25','172.21.3.86','fidelis','2013-01-18 17:11:37','172.21.2.4'),('06086611050901','Jhon Kepler Pangaribuan','','Laki-laki','','1966-08-09','K-3','2009-05-11','Satpam','Satpam','Aktif','Yacab','','Kontrak',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:07:51','172.21.3.86','good','2011-04-27 15:01:27','172.23.2.145'),('06107301040501','Sabar Simanjuntak','','Laki-laki','','1973-10-06','K-5','2005-04-01','Pengemudi','Pengemudi','Aktif','Yacab','','Kontrak',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:36:26','172.21.3.86','good','2011-04-27 15:25:32','172.23.2.145'),('07039005091101','Tulus Pardamean Simanjuntak','Tulus','Laki-laki','Tarutung','1990-03-07','TK','2011-09-05','Duktek','Duktek','Aktif','IT Del','M','Tetap',0,'D3','D3',NULL,NULL,'A.Md',NULL,'fidelis','2012-03-08 09:32:44','172.21.3.76','inte','2013-02-25 15:33:10','172.21.3.79'),('07069007091101','Elis Yani Sibarani','Elis','Perempuan','Pematang Siantar','1990-06-07','TK','2011-09-07','Staf','Pustakawan','Keluar','IT Del','S','Tetap',0,'D3','D3',NULL,NULL,'A.Md',NULL,'fidelis','2012-03-08 08:59:06','172.21.3.76','fidelis','2013-09-19 11:41:28','172.21.6.11'),('07088601070901','Rina Sibuea','RNS','Perempuan','','1986-08-07','TK','2009-07-01','Dosen','Dosen','Keluar','IT Del','S','Tetap',NULL,'S1','S1',NULL,NULL,NULL,NULL,'arya','2011-02-18 21:34:24','172.21.3.86','inte','2012-01-18 15:53:01','172.23.2.14'),('07117625071101','Parlin Pangaribuan','Parlin','Laki-laki','Pintu Bosi','1976-11-07','TK','2011-07-25','Maintenance','Maintenance','Aktif','Yacab','L','Kontrak',NULL,'D3','D3',NULL,NULL,NULL,NULL,'gerry','2012-10-19 16:04:48','172.21.1.33',NULL,NULL,NULL),('08017601030801','Binsar H. Hutagaol','','Laki-laki','Sigumpar','1976-01-08','K-3','2008-03-01','Pengemudi','Pengemudi','Aktif','Yacab','L','Kontrak',NULL,'SMK','SMK',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:41:17','172.21.3.86','arya','2011-04-01 16:11:59','172.21.3.86'),('08029217091301','Daniel Sitorus ','Daniel','Perempuan','Medan','1992-02-08','TK','2013-09-17','Duktek','Duktek','Aktif','IT Del','M','Kontrak',0,'D3','D3','Duktek','','A.Md','Duktek','fidelis','2013-09-19 11:19:35','172.21.6.11',NULL,NULL,NULL),('08037615090101','Tiurma Lumban Gaol','TLG','Perempuan','','1976-03-08','K-1','2001-09-15','Kepala Perpustakaan','Kepala Perpustakaan','TSDP','IT Del','M','Tetap',NULL,'S1','S1',NULL,NULL,NULL,NULL,'arya','2011-02-18 21:21:50','172.21.3.86','fidelis','2014-07-02 14:04:34','172.21.2.2'),('08057626081301','Rumondang Miranda Marsaulina','Rumondang','Perempuan','Jakarta','1976-05-08','TK','2013-08-26','Dosen','Dosen','Aktif','','XL','Kontrak',0,'S2','S2','Dosen','','M.Si','Dosen','fidelis','2013-08-28 10:29:08','172.21.2.47',NULL,NULL,NULL),('08068121051301','Rini Hutajulu','Rini','','Laguboti','1981-06-08','TK','2013-05-21','Bapak/Ibu Asrama','Bapak/Ibu Asrama','Aktif','IT Del','L','Kontrak',NULL,'S1','S1','Ibu Asrama',NULL,'S.Th','Ibu Asrama','fidelis','2013-05-23 15:55:38','172.21.2.47',NULL,NULL,NULL),('08077911050901','Rizal pangaribuan','','Laki-laki','','1979-07-08','K-3','2009-05-11','Satpam','Satpam','Aktif','Yacab','','Tetap',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:09:21','172.21.3.86','gerry','2012-10-19 14:58:38','172.21.1.33'),('08078810081101','Anthony L Tampubolon','Anthony','Laki-laki','Jakarta','1988-07-08','TK','2011-08-10','Staf','Staf','Aktif','IT Del','L','Kontrak',NULL,'S1','S1','','','S.Pd','','fidelis','2012-03-08 08:54:56','172.21.3.76',NULL,NULL,NULL),('08098320030701','Marojahan Mula Timbul Sigiro','MMS','Laki-laki','','1983-09-08','TK','2007-03-20','Ass Dosen','Dosen','Aktif','IT Del','XL','Tetap',NULL,'D3','S1','Dosen','ST','M.Sc','Dosen','arya','2011-02-18 20:52:03','172.21.3.86','fidelis','2012-11-29 08:47:53','172.21.2.253'),('08118913080901','Jonni Fridles Silaban','Jonni','Laki-laki','','1989-11-08','TK','2009-08-13','Duktek','Duktek','Keluar','IT Del','','Kontrak',NULL,'SMK','SMK',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:01:59','172.21.3.86','fidelis','2012-03-07 09:00:32','172.21.3.76'),('08127819040201','Imelda Rinawaty Simanjuntak','IMS','Perempuan','','1978-12-08','K-1','2002-04-19','Dosen','Dosen','Keluar','IT Del','','Tetap',NULL,'S1','S2',NULL,NULL,NULL,NULL,'arya','2011-02-18 20:29:07','172.21.3.86','inte','2012-12-09 21:41:48','172.23.2.208'),('09018315021001','Sahat Siahaan','SAHAT','Laki-laki','Onan Sampang','1983-01-09','TK','2010-02-15','Pengemudi','Pengemudi','Aktif','Yacab','M','Kontrak',NULL,'SMK','SMK',NULL,NULL,NULL,NULL,'gerry','2012-10-19 15:55:20','172.21.1.33','gerry','2012-10-19 15:58:39','172.21.1.33'),('09047801120301','Rindu  Siagian','','Laki-laki','','1978-04-09','K-3','2003-12-01','CS','CS','Aktif','Yacab','','Tetap',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:18:18','172.21.3.86','good','2011-04-27 15:19:28','172.23.2.145'),('09087615090101','Maria Emmanuelly Siahaan','MES','Perempuan','','1976-08-09','K-2','2001-09-15','Dosen','Dosen','Keluar','IT Del','L','Tetap',NULL,'S1','S1',NULL,NULL,NULL,NULL,'arya','2011-02-18 20:26:41','172.21.3.86','inte','2012-01-18 15:50:05','172.23.2.14'),('09088301040501','Bangkit Marpaung','','Laki-laki','Hutaginjang','1983-08-09','TK','2005-04-01','Taman','Taman','Aktif','Yacab','M','Kontrak',NULL,'SMK','SMK',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:34:50','172.21.3.86','good','2011-04-27 14:44:13','172.23.2.145'),('10017801010201','Parlinggoman Napitupulu','','Laki-laki','','1978-01-10','K-2','2002-01-01','Maintenance','Maintenance','Aktif','Yacab','','Tetap',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:35:26','172.21.3.86','good','2011-12-21 05:55:28','172.23.2.7'),('10026901100101','Darwin S. Napitupulu','','Laki-laki','Sigumpar','1969-02-10','K-4','2001-10-01','Satpam','Satpam','Aktif','Yacab','L','Tetap',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:54:08','172.21.3.86','good','2011-04-27 14:48:06','172.23.2.145'),('10033601071001','Jorga Ibrahim','Jorga','Laki-laki','Pangkal Pinang/ 10 Maret  1936','1936-03-10','K-0','2010-07-01','Dosen','Dosen','Aktif','IT Del','XL','Kontrak',NULL,'S3','S3','Dosen','Prof','M.Sc','Dosen','fidelis','2012-05-04 15:10:56','172.21.3.76',NULL,NULL,NULL),('10039229081301','Rini Juliana Sipahutar, A.Md','Rini','Perempuan','Kabanjahe','1992-03-10','TK','2013-08-29','Staf','Staf','Aktif','IT Del','S','Kontrak',0,'D3','D3','Staf',NULL,'A.Md','Staf','fidelis','2013-09-11 16:11:38','172.21.6.11',NULL,NULL,NULL),('10049016071201','Apriando Jonathan Rajagukguk','Ando','Laki-laki','Jawa Maraja','1990-04-10','TK','2012-07-16','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Keluar','IT Del','XL','Kontrak',NULL,'S1','S1',NULL,NULL,NULL,NULL,'gerry','2012-10-19 16:46:45','172.21.1.33','fidelis','2013-04-10 10:48:13','172.21.2.34'),('10078105100901','Bettina Simanjutak','','Perempuan','Sigumpar','1983-07-10','TK','2009-10-05','Taman','Taman','Aktif','Yacab','L','Kontrak',NULL,'S1','S1',NULL,NULL,'S.P.',NULL,'arya','2011-02-18 22:51:29','172.21.3.86','good','2011-04-27 14:46:40','172.23.2.145'),('10098008090101','Berlin Napitupulu','','Laki-laki','','1980-09-10','K-2','2001-09-08','Maintenance','Maintenance','Aktif','Yacab','','Tetap',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:27:25','172.21.3.86','good','2011-04-27 14:45:08','172.23.2.145'),('10098615090801','Eka Trisno Samosir','Eka','Laki-laki','','1986-09-10','TK','2008-09-15','Ass Dosen','Ass Dosen','Keluar','IT Del','','Kontrak',NULL,'D3','D3',NULL,NULL,NULL,NULL,'arya','2011-02-18 21:13:49','172.21.3.86','good','2011-03-18 15:06:34','172.23.2.244'),('10117613080101','Tennov Simanjuntak','THS','Laki-laki','','1976-11-10','K-3','2001-08-13','Dosen','Dosen','Aktif','IT Del','L','Tetap',NULL,'S1','S2',NULL,NULL,NULL,NULL,'arya','2011-02-18 19:07:11','172.21.3.86','inte','2012-01-18 15:48:18','172.23.2.14'),('10118206031201','Hendrik Andreas Siagian','Hendrik','Laki-laki','Tanjung Balai','1982-11-10','TK','2012-03-06','Pengemudi','Pengemudi','Aktif','Yacab','L','Harian',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'gerry','2012-10-19 16:22:21','172.21.1.33',NULL,NULL,NULL),('10129217091301','Irmandes Roy M Tambunan','Irmandes','Laki-laki','Balige','1992-12-10','TK','2013-09-17','Duktek','Duktek','Aktif','IT Del','M','Kontrak',0,'D3','D3','Duktek','A.Md','A.Md','Duktek','fidelis','2013-09-19 11:16:20','172.21.6.11',NULL,NULL,NULL),('11038920091001','Sabar M. Tampubolon ','SMT','Laki-laki','','1989-03-11','TK','2010-09-20','Ass Dosen','Ass Dosen','Keluar','IT Del','','Tetap',NULL,'D3','D3','II/D',NULL,'Amd.','II/D','good','2011-04-01 13:33:12','172.23.2.145','edwin','2012-10-12 11:11:14','172.21.2.2'),('11045601100101','Ramot Pangaribuan ','','Laki-laki','','1956-04-11','K-5','2001-10-01','CS','CS','Aktif','Yacab','','Tetap',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:58:45','172.21.3.86','good','2011-04-27 15:17:31','172.23.2.145'),('11067801120301','Rudi Silalahi','','Laki-laki','','1978-06-11','K-3','2003-12-01','Maintenance','Maintenance','Aktif','Yacab','','Tetap',NULL,'SMK','SMK',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:31:25','172.21.3.86','good','2011-04-27 15:23:39','172.23.2.145'),('11069305091101','Josefh Hasudungan Simanjuntak','Josefh','Laki-laki','Aek Natolu','1993-06-11','TK','2011-09-05','Duktek','Duktek','Aktif','IT Del','S','Kontrak',0,'SMK','SMK',NULL,NULL,NULL,NULL,'fidelis','2012-03-08 09:36:25','172.21.3.76',NULL,NULL,NULL),('11088101090201','Morris Marpaung','','Laki-laki','','1981-08-11','TK','2002-09-01','CS','CS','Aktif','Yacab','','Tetap',NULL,'SMP','',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:13:40','172.21.3.86','good','2011-04-27 15:08:20','172.23.2.145'),('11098602031101','Farida Rafli Mudur Simorangkir','','Perempuan','Pekanbaru','1986-09-11','TK','2011-03-02','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Keluar','IT Del','','Harian',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'good','2011-04-01 20:49:43','172.21.3.127','fidelis','2012-02-20 10:45:47','172.21.3.76'),('11105701010801','Herry DS Pasaribu','HDP','Laki-laki','Bandung','1957-10-11','K-3','2008-01-01','Wakil Direktur Bidang Administrasi Umum dan Sumber Daya','Staf Ahli','Keluar','Yacab','','Kontrak',NULL,'S2','S2',NULL,'Drs.','MM',NULL,NULL,NULL,NULL,'fidelis','2012-02-20 10:47:58','172.21.3.76'),('11106101051001','Tresno Sibuea','','Laki-laki','','1961-10-11','K-2','2010-05-01','Staf','Staf','Keluar','Yacab','XL','Kontrak',NULL,'SMK','SMK',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:49:07','172.21.3.86','gerry','2012-10-18 16:26:23','172.21.1.33'),('1111111111','Ujicoba','UJI','Perempuan','Testing','0000-00-00','K-0','0000-00-00','Testing','Testing','Aktif','IT Del','L','Kontrak',NULL,'S1','S1','III','','S.KOM','','','0000-00-00 00:00:00','','','0000-00-00 00:00:00',''),('12018606071201','Nora Nastity Simanjuntak','Nora','Perempuan','Balige','1986-01-12','TK','2012-07-06','Staf','Staf','Aktif','','M','Tetap',0,'S1','S1','staf inventori merangkap guru PAUD','','S.Pd','staf inventori merangkap guru PAUD','fidelis','2012-07-09 10:15:17','172.21.3.76','fidelis','2014-07-02 14:29:46','172.21.2.2'),('12049110091201','Ester Afriany SImatupang ','Ester','Perempuan','Tarutung','1991-04-12','TK','2012-09-10','Ass Dosen','Ass Dosen','Keluar','IT Del','S','Kontrak',NULL,'S1','D3','Asdos',NULL,'A.Md','Asdos','fidelis','2012-10-12 11:46:59','172.21.2.253','fidelis','2013-09-19 11:43:03','172.21.6.11'),('12058401040901','Sarmaida Pasaribu','','Perempuan','Belawan','1984-05-12','TK','2009-04-01','Staf','Staf','Aktif','Yacab','L','Kontrak',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:48:51','172.21.3.86','good','2011-04-27 15:27:50','172.23.2.145'),('12058506021201','Verawaty Situmorang','VES','Perempuan','Balige','1985-05-12','K-1','2012-02-06','Dosen','Dosen','TSDP','IT Del','S','Tetap',0,'S1','S1',NULL,NULL,'S.Kom',NULL,'fidelis','2012-03-08 10:15:30','172.21.3.76','fidelis','2014-07-02 14:27:03','172.21.2.2'),('12086202051001','Aman Siahaan','AMAN','Laki-laki','','1962-08-12','K-3','2010-05-02','Satpam','Satpam','Aktif','Yacab','L','Kontrak',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'good','2011-03-18 11:53:20','172.23.2.244','togu','2012-06-17 23:30:32','172.21.3.167'),('12108802031101','Henriko Sihotang','','Laki-laki','Sihotang Pardomuan','1988-10-12','TK','2011-03-02','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Keluar','IT Del','','Harian',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'good','2011-04-01 20:32:42','172.21.3.127','gerry','2012-10-19 15:12:47','172.21.1.33'),('12119305091101','Yanti Nuraya Situmorang','Yanti','Perempuan','Aek Natolu','1993-11-12','TK','2011-10-17','Pustakawan','Pustakawan','Keluar','IT Del','S','Kontrak',0,'SMA','SMA',NULL,NULL,NULL,NULL,'fidelis','2012-03-08 09:44:46','172.21.3.76','gerry','2012-10-18 16:31:29','172.21.1.33'),('13048815021001','Mariani Theresia Simatupang','MAR','Perempuan','Pematang Siantar','1988-04-13','TK','2010-02-15','Ass Dosen','Dosen','Keluar','IT Del','S','Kontrak',0,'S1','S1',NULL,NULL,'S.Pd',NULL,'fidelis','2012-03-08 09:53:38','172.21.3.76','fidelis','2013-03-12 09:37:24','172.21.2.4'),('13068701031201','Immanuel Panjaitan','Immanuel','Laki-laki','Medan','1987-06-13','K-0','1987-06-13','Ass Dosen','Ass Dosen','TSDP','IT Del','M','Tetap',0,'D3','D3','asisten dosen','','A.Md','asisten dosen','fidelis','2013-03-28 17:22:40','172.21.2.34','fidelis','2014-07-02 14:32:21','172.21.2.2'),('13108501021001','Dorlan Malau','Dorlan','Perempuan','','1985-10-13','K-1','2010-02-01','Staf','Staf','Aktif','IT Del','M','Tetap',NULL,'S1','S1',NULL,NULL,'S.E.',NULL,'good','2011-04-01 11:59:40','172.23.2.145','fidelis','2014-07-02 14:22:52','172.21.2.2'),('14017910030301','Deni Parlindungan Lumbantoruan','DLT','Laki-laki','Siborong-borong','1979-01-14','K-2','2003-03-10','Dosen','Ketua LPPM','Aktif','IT Del','','Tetap',NULL,'S1','S2',NULL,NULL,NULL,NULL,'arya','2011-03-18 15:50:44','172.21.3.86','gerry','2012-11-23 16:11:28','172.21.1.33'),('14039214100301','Marcella Delicia Tambunan','Marcella ','Perempuan','Balige','1992-03-14','TK','2013-10-14','Staf','Staf','Aktif','IT Del','S','Kontrak',0,'D3','D3','staf','','A.Md','Staf','fidelis','2013-10-22 08:19:43','172.21.6.11',NULL,NULL,NULL),('14044217090701','Tahan Hutahaean','THT','Laki-laki','','1942-04-14','','2007-09-17','Dosen','Dosen','Keluar','IT Del','L','Kontrak',NULL,'S2','S2',NULL,NULL,NULL,NULL,'arya','2011-02-18 21:04:06','172.21.3.86','fidelis','2013-01-18 17:10:02','172.21.2.4'),('14058025080801','Nurani Pangaribuan','','Perempuan','','1980-05-14','TK','2008-08-25','Staf','Staf','Keluar','IT Del','','Tetap',NULL,'SMK','SMK',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:45:30','172.21.3.86','togu','2012-02-20 11:20:41','172.21.251.124'),('14061001078501','Lismawaty Simanjuntak','Lisma','Perempuan','Tanotur','1985-07-01','TK','2010-06-14','Suster Klinik','Suster Klinik','Aktif','IT Del','M','Harian',NULL,'D3','D3','suster klinik','','A.Md','suster klinik','fidelis','2012-05-04 17:38:53','172.21.3.76',NULL,NULL,NULL),('14103701010401','Saswinadi Sasmojo','SAS','Laki-laki','Pati','1937-10-14','K-2','2004-01-01','Direktur','Dosen','Aktif','IT Del','','Kontrak',NULL,'S3','S3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'good','2011-05-27 23:22:27','172.21.2.173'),('15017713080101','Arnaldo Marulitua Sinaga','AMS','Laki-laki','','1977-01-15','K-2','2001-08-13','Dosen','Wakil Direktur Bidang Administrasi Umum dan Sumber Daya','Aktif','IT Del','','Tetap',NULL,'S1','S2',NULL,NULL,NULL,NULL,'arya','2011-02-18 20:10:05','172.21.3.86','fidelis','2014-07-02 14:00:50','172.21.2.2'),('15077801070201','Perry Pangaribuan','','Laki-laki','','1978-07-15','K-2','2002-07-01','Satpam','Satpam','Aktif','Yacab','','Tetap',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:05:29','172.21.3.86','gerry','2012-10-19 14:57:15','172.21.1.33'),('15088609071201','Denny Elvin Hutagaol','Denny','Laki-laki','Medan','1986-08-15','TK','2012-07-09','Staf','Staf','Aktif','IT Del','XL','Tetap',0,'S1','S1','staf maintenance merangkap Duktek','','ST','staf maintenance merangkap Duktek','fidelis','2012-07-09 10:20:32','172.21.3.76','fidelis','2014-07-02 14:30:04','172.21.2.2'),('15117801091201','Danang Junaedi ','Danang','Laki-laki','Jogjakarta','1978-11-15','TK','2012-09-01','Dosen','Dosen','Aktif','IT Del','','Tetap',0,'S2','S2','Dosen',NULL,'MT','Dosen','fidelis','2013-01-18 17:24:56','172.21.2.4','fidelis','2014-07-02 14:31:18','172.21.2.2'),('16015301100701','Inggriani','IL','Perempuan','','1953-01-16','','2007-10-01','Dosen','Staf Ahli','Aktif','IT Del','S','Kontrak',NULL,'S3','S3',NULL,'Dr.',NULL,NULL,'arya','2011-02-18 21:36:56','172.21.3.86','gerry','2012-10-19 15:37:03','172.21.1.33'),('16018816072012','Elisabeth Pasaribu','Elisabeth','Perempuan','Samarinda','1988-01-16','TK','2012-07-16','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Keluar','IT Del','M','Kontrak',0,'S1','S1',NULL,NULL,NULL,NULL,'gerry','2012-10-19 16:44:14','172.21.1.33','fidelis','2013-04-10 10:47:27','172.21.2.34'),('16029213080901','Friska Silaban','Friska','Perempuan','','1992-02-16','TK','2009-08-13','Staf','Staf','Keluar','IT Del','S','Kontrak',NULL,'SMK','SMK',NULL,NULL,NULL,NULL,'good','2011-04-01 12:16:10','172.23.2.145','fidelis','2012-03-07 09:05:30','172.21.3.76'),('16047301090201','Johannes Harungguan Sianipar','JHS','Laki-laki','','1973-04-16','K-1','2002-09-01','Dosen','Dosen','TSDP','IT Del','XL','Tetap',NULL,'S1','S2','','','','','arya','2011-02-18 20:17:42','172.21.3.86','fidelis','2014-07-02 13:59:28','172.21.2.2'),('16049214021101','Joel Kosay ','Joel','Laki-laki','Wamena','1992-04-16','TK','2011-02-14','Staf','Staf','Keluar','IT Del','','Kontrak',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'good','2011-04-01 13:21:06','172.23.2.145','fidelis','2013-09-19 11:44:16','172.21.6.11'),('16098301061101','Andrey Simatupang','Andrey','Laki-laki','Tanjung Morawa','1983-09-16','K-1','2011-06-01','Maintenance','Maintenance','Aktif','Yacab','L','Kontrak',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'gerry','2012-10-19 16:01:02','172.21.1.33',NULL,NULL,NULL),('16108521070801','Kisno Shinoda','KIS','Laki-laki','','1985-10-16','TK','2008-07-21','Ass Dosen','Dosen','Aktif','IT Del','','Harian',NULL,'S1','S1',NULL,NULL,NULL,NULL,'arya','2011-02-18 21:09:59','172.21.3.86','fidelis','2014-07-02 14:03:50','172.21.2.2'),('16108528011301','Kisno','Kisno','Laki-laki','Kisaran','1985-10-16','TK','2013-01-28','Ass Dosen','Ass Dosen','Aktif','IT Del','L','Harian',0,'S1','S1','asisten dosen','S.Pd',NULL,'Asisten Dosen','fidelis','2013-01-31 13:49:46','172.21.2.4',NULL,NULL,NULL),('17018201090201','Oberlin Pangaribuan','','Laki-laki','','1982-01-17','K-2','2002-09-01','Maintenance','Maintenance','Aktif','Yacab','','Tetap',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:04:42','172.21.3.86','good','2011-12-21 05:54:49','172.23.2.7'),('17027929110201','Arlinta Christy Barus','ACB','Perempuan','','1979-02-17','K-2','2002-11-29','Dosen','Wakil Direktur Bidang Akademik dan Kemahasiswaan','Aktif','IT Del','M','Tetap',NULL,'S1','S2',NULL,NULL,NULL,NULL,'arya','2011-02-18 20:22:14','172.21.3.86','fidelis','2014-07-02 14:01:46','172.21.2.2'),('17048809071201','Indra Sarito Lumbantobing','Indra','Laki-laki','Tarutung','1988-04-17','TK','2012-07-09','Staf','Staf','Aktif','IT Del','XL','Tetap',0,'S1','S1','staf WD 3/LPPM','','S.Pd','Staf WD3/LPPM','fidelis','2012-07-09 10:23:52','172.21.3.76','fidelis','2014-07-02 14:30:22','172.21.2.2'),('17076701050601','Adi Pulo Niko','','Laki-laki','Simpang Semadam','1967-07-17','K-1','2006-05-01','Taman','Taman','Aktif','Yacab','M','Kontrak',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:33:27','172.21.3.86','good','2011-04-01 11:10:51','172.23.2.145'),('17078510011201','Sugianto Napitupulu','Sugianto','Laki-laki','Sigumpar','1985-07-17','TK','2012-01-10','CS','CS','Aktif','Yacab','L','Harian',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'gerry','2012-10-19 16:17:25','172.21.1.33',NULL,NULL,NULL),('17078715090801','Eka Stephani Sinambela','ESS','Perempuan','','1987-07-17','TK','2008-09-15','Ass Dosen','Ass Dosen','Aktif','IT Del','M','Tetap',NULL,'D3','D3',NULL,NULL,NULL,NULL,'arya','2011-02-18 21:15:32','172.21.3.86','fidelis','2013-04-10 15:35:36','172.21.2.34'),('17089129081301','Goklas Panjaitan','Goklas','Laki-laki','Huta Harambir ','1991-08-17','TK','2013-08-29','Staf','Staf','Aktif','IT Del','M','Kontrak',0,'D3','D3','Staf','','A.Md','Staf','fidelis','2013-09-11 16:14:51','172.21.6.11',NULL,NULL,NULL),('18018005050801','Bony Parulian Josaphat Marbun','BPM','Laki-laki','','1980-01-18','K-1','2008-05-05','Dosen','Dosen','Keluar','IT Del','XL','Tetap',NULL,'S2','S2',NULL,NULL,NULL,NULL,'arya','2011-02-18 21:06:17','172.21.3.86','good','2011-03-18 15:05:50','172.23.2.244'),('18018306090401','Imelda Doharta Aritonang','IDA','Perempuan','','1983-01-18','TK','2004-09-06','Duktek','Ass Dosen','Keluar','IT Del','','Tetap',NULL,'D3','D3',NULL,NULL,NULL,NULL,'arya','2011-02-18 20:46:01','172.21.3.86','inte','2012-12-09 21:44:14','172.23.2.208'),('18038801081201','Depni Leliani Situmorang','Depni','Perempuan','Bagotpuloan','1988-03-18','TK','2012-08-01','Ass Dosen','Ass Dosen','Keluar','IT Del','S','Harian',NULL,'S1','S1','Asdos',NULL,'S.Pd','Asdos','fidelis','2012-10-12 11:27:37','172.21.2.253','fidelis','2013-01-18 17:15:56','172.21.2.4'),('18038813080901','Jokie Andi Nababan','Jokie','Laki-laki','','1988-03-18','TK','2009-08-13','Duktek','Duktek','Keluar','IT Del','','Kontrak',NULL,'SMK','SMK',NULL,NULL,NULL,NULL,'arya','2011-02-18 21:53:33','172.21.3.86','fidelis','2012-03-07 08:59:59','172.21.3.76'),('18046722081101','Ramson Marpaung','Ramson','Laki-laki','Balige','1967-04-18','K-5','2011-08-22','CS','CS','Aktif','Yacab','L','Kontrak',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'gerry','2012-10-19 16:06:35','172.21.1.33',NULL,NULL,NULL),('18049105091101','Artati Caroline Ruth Tampubolon','Artati','Perempuan','Jakarta','1991-04-18','TK','2011-09-05','Ass Dosen','Ass Dosen','Keluar','IT Del','','Kontrak',NULL,'D3','D3',NULL,'','A.Md',NULL,'fidelis','2012-03-08 09:20:41','172.21.3.76',NULL,NULL,NULL),('18058629051301','Refindo Hutagalung','Refindo','Laki-laki','Mulyorejo','1986-05-18','TK','2013-05-29','Bapak/Ibu Asrama','Bapak/Ibu Asrama','Aktif','IT Del','L','Kontrak',NULL,'S1','S1','Bapak asrama','','S.Th','Bapak asrama','fidelis','2013-05-29 09:41:15','172.21.2.47',NULL,NULL,NULL),('18098402020901','Roy Kardo Panjaitan','','Laki-laki','','1984-09-18','TK','2009-02-02','Satpam','Satpam','Aktif','Yacab','','Kontrak',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:11:57','172.21.3.86','good','2011-04-27 15:21:53','172.23.2.145'),('18118220030701','Inte Christinawati Buulolo','ICB','Perempuan','Gunung Sitoli','1982-11-18','K-0','2007-03-20','Ass Dosen','Dosen','Aktif','IT Del','S','Tetap',NULL,'D3','S1',NULL,'A.Md','ST','','arya','2011-02-18 20:54:29','172.21.3.86','fidelis','2014-07-04 17:00:56','172.21.2.2'),('19017608080601','Jonang Silalahi','','Laki-laki','','1976-01-19','K-1','2006-08-08','Maintenance','Maintenance','Aktif','Yacab','','Tetap',NULL,'S1','S1',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:37:14','172.21.3.86','good','2011-12-21 05:56:29','172.23.2.7'),('19018802031101','Jetti Lisantri Samosir','','Perempuan','Dumai','1988-01-19','TK','2011-03-02','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Keluar','IT Del','','Harian',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'good','2011-04-01 20:47:04','172.21.3.127','fidelis','2012-02-20 10:45:02','172.21.3.76'),('19029006031201','Erhan Gabriel Sihombing','Erhan','Laki-laki','Jakarta','1990-02-19','TK','2012-03-06','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Aktif','IT Del','M','Harian',NULL,'S1','S1',NULL,NULL,NULL,NULL,'fidelis','2012-03-08 10:22:26','172.21.3.76','gerry','2012-10-19 16:47:58','172.21.1.33'),('19039110091201','Sumiati Hutagalung','Sumiati','','Balige','1991-03-19','TK','2012-09-10','Ass Dosen','Ass Dosen','Keluar','IT Del','S','Kontrak',NULL,'D3','D3','Asisten dosen','','A.Md','Asisten dosen','fidelis','2012-10-12 11:43:26','172.21.2.253','fidelis','2013-10-30 15:33:04','172.21.6.11'),('19048906031201','Toni Nainggolan','Toni','Laki-laki','Pematang Ibul','1989-04-19','TK','2012-03-06','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Keluar','IT Del','S','Harian',NULL,'S1','S1',NULL,NULL,NULL,NULL,'fidelis','2012-03-08 10:27:14','172.21.3.76','gerry','2012-10-19 15:15:09','172.21.1.33'),('19068922060901','Daniel Girsang','','Laki-laki','Bandar Tongging','1989-06-19','TK','2009-06-22','Satpam','Satpam','Aktif','Yacab','L','Kontrak',NULL,'SMK','SMK',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:43:33','172.21.3.86','good','2011-04-27 14:47:34','172.23.2.145'),('19069217091301','Denni Prima Putra Roli','Denni','Laki-laki','Porsea','1992-06-19','TK','2013-09-17','Duktek','Duktek','Aktif','IT Del','M','Kontrak',0,'D3','D3','Duktek','','A.Md','Duktek','fidelis','2013-09-19 11:24:37','172.21.6.11','fidelis','2014-07-02 14:33:29','172.21.2.2'),('19089305091101','Bezaleel Hutasoit','Beksal','Laki-laki','Bekasi','1993-08-19','TK','2011-09-05','Duktek','Duktek','Keluar','IT Del','S','Kontrak',NULL,'SMK','SMK',NULL,NULL,NULL,'','fidelis','2012-03-08 09:41:02','172.21.3.76','gerry','2012-10-18 16:30:17','172.21.1.33'),('19098005010901','Leo Lumban Toruan','','Laki-laki','','1980-09-19','K-1','2009-01-05','Maintenance','Maintenance','Aktif','Yacab','','Kontrak',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:39:27','172.21.3.86','good','2011-04-27 15:05:12','172.23.2.145'),('19117111050901','Menak Napitupulu','','Laki-laki','','1971-11-19','K-3','2009-05-11','Satpam','Pengemudi','Aktif','Yacab','','Kontrak',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:40:07','172.21.3.86','gerry','2012-10-19 15:38:01','172.21.1.33'),('20018717051301','Jhon Batara Lelan Siahaan','Jhon','Laki-laki','Sigumpar','1987-01-20','TK','2013-05-17','Staf','Staf','Aktif','IT Del','L','Kontrak',0,'S1','S1','Staf','','S.Kom','Staf','fidelis','2013-05-21 10:28:05','172.21.2.34',NULL,NULL,NULL),('20027329060901','Berton Panjaitan','','Laki-laki','Sitoluama','1973-02-20','K-3','2009-06-29','Maintenance','Maintenance','Aktif','Yacab','L','Kontrak',NULL,'SMK','SMK',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:41:21','172.21.3.86','good','2011-04-01 11:16:26','172.23.2.145'),('20058201100101','Rudi Coys Pakpahan','','Laki-laki','','1982-05-20','TK','2001-10-01','Taman','Taman','Aktif','Yacab','','Tetap',NULL,'SMP','',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:06:37','172.21.3.86','good','2011-04-27 15:23:02','172.23.2.145'),('20058625101301','Rusneni Vitaria ','Rusneni','Perempuan','Kabanjahe','1986-05-20','TK','2013-10-24','Staf','Staf','Aktif','IT Del','S','Kontrak',0,'S1','S1','Staf',NULL,'S.Hut','Staf','fidelis','2013-10-25 14:58:30','172.21.6.11',NULL,NULL,NULL),('20067306100801','Jerry Pangaribuan','','Laki-laki','Sitoluama','1973-06-20','K-2','2008-10-06','Taman','Taman','Aktif','Yacab','L','Kontrak',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:31:22','172.21.3.86','good','2011-04-27 15:00:31','172.23.2.145'),('20077415090101','Lisbeth Mariana Simanjuntak','Anna','Perempuan','','1974-07-20','TK','2001-09-15','Kepala Bagian Tata Usaha','Kepala Bagian Tata Usaha','TSDP','IT Del','S','Tetap',NULL,'S1','S1','III/A',NULL,'S.S.','III/B','good','2011-04-01 11:49:26','172.23.2.145','gerry','2012-10-18 16:27:09','172.21.1.33'),('20078510011201','Wiwin Sry Adinda Banjarnahor','WSA','Perempuan','Medan','1985-07-20','TK','2012-01-10','Dosen','Dosen','TSDP','IT Del','M','Tetap',0,'S1','S1',NULL,NULL,'S.Kom',NULL,'fidelis','2012-03-08 10:10:57','172.21.3.76','fidelis','2014-07-02 14:26:25','172.21.2.2'),('20097902020901','Anwar Pangaribuan','','Laki-laki','','1979-09-20','K-2','2009-02-02','Satpam','Satpam','Aktif','Yacab','','Tetap',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:10:28','172.21.3.86','gerry','2012-10-19 14:59:00','172.21.1.33'),('21018301060501','Rentauli Mariah  Silalahi','RMS','Perempuan','','1983-01-21','K-0','2005-06-01','Dosen','Dosen','Aktif','IT Del','','Tetap',NULL,'S1','S2',NULL,NULL,NULL,NULL,'arya','2011-02-18 20:39:54','172.21.3.86','fidelis','2014-07-02 14:00:29','172.21.2.2'),('21018501120601','Larisma Simanjuntak','','Perempuan','Matio','1985-01-21','TK','2006-12-01','Pustakawan','Pustakawan','Aktif','IT Del','','Tetap',NULL,'D3','S1',NULL,NULL,NULL,NULL,'arya','2011-02-18 21:47:49','172.21.3.86','fidelis','2014-07-02 14:06:02','172.21.2.2'),('21038301081201','Elida Lamria Siahaan','Elida','','Pararung','1983-03-21','TK','2012-08-01','Staf','Staf','Aktif','IT Del','S','Tetap',0,'S1','S1','Staf','','S.Kom','Staf','fidelis','2012-10-12 11:17:15','172.21.2.253','fidelis','2014-07-02 14:28:47','172.21.2.2'),('21038428090901','Roy Deddy Hasiholan Lumban Tobing','RDT','Laki-laki','','1984-03-21','K-0','2009-09-28','Ass Dosen','Dosen','TSDP','IT Del','L','Tetap',NULL,'D3','S1','',NULL,NULL,NULL,'arya','2011-02-18 21:26:23','172.21.3.86','fidelis','2014-07-02 08:51:19','172.21.2.2'),('21049217091301','Kamaruddin Manullang','Kamaruddin ','Laki-laki','Dairi Bagasan ','1992-04-21','TK','2013-09-17','Staf','Staf','Aktif','IT Del','M','Kontrak',0,'D3','D3','Staf','','A.Md','Staf','fidelis','2013-09-19 11:31:32','172.21.6.11',NULL,NULL,NULL),('21078726031201','Prima Heptayana Nainggolan','Prima','Perempuan','Depok','1987-07-21','TK','2012-03-26','Dokter Kampus','Dokter Kampus','Keluar','IT Del','','Kontrak',NULL,'S1','S1','dokter kampus','dr','','dokter kampus','fidelis','2012-04-13 08:51:00','172.21.3.76','fidelis','2014-07-02 14:27:32','172.21.2.2'),('21097613080101','Yaya Setiyadi','YYS','Laki-laki','','1976-09-21','K-0','2001-08-13','Dosen','Dosen','Aktif','IT Del','M','Tetap',NULL,'S1','S2','','',NULL,'','arya','2011-02-18 19:14:32','172.21.3.86','fidelis','2012-02-20 10:37:38','172.21.3.76'),('21099117091301','Markus M.M.Panjaitan','Markus','Laki-laki','Medan ','1991-09-21','TK','2013-09-17','Staf','Staf','Aktif','IT Del','M','Kontrak',NULL,'D3','D3','Staf','','A.Md','Staf','fidelis','2013-09-19 11:28:26','172.21.6.11',NULL,NULL,NULL),('22026301100101','Charles Pangaribuan','','Laki-laki','Sitoluama','1963-02-22','K-4','2001-10-01','Pengemudi','Pengemudi','Meninggal','Yacab','','Tetap',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-04-01 16:27:14','172.21.3.86','good','2011-04-27 15:32:31','172.23.2.145'),('22039329081301','Rony Friendy Tampubolon','Ronny','Laki-laki','Parapat','1993-03-22','TK','2013-08-29','Ass Dosen','Ass Dosen','Aktif','IT Del','S','Kontrak',0,'D3','D3','Asisten Dosen',NULL,'A.Md','Asisten Dosen','fidelis','2013-09-11 16:04:03','172.21.6.11',NULL,NULL,NULL),('22058502031101','Jones Beatri Panjaitan','','Laki-laki','Medan','1985-05-22','TK','2011-03-02','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Keluar','IT Del','','Harian',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'good','2011-04-01 20:35:36','172.21.3.127','fidelis','2012-02-20 10:47:03','172.21.3.76'),('22068301031301','Johanes Pardede','Johanes','Laki-laki','Medan','1983-06-22','K-0','2013-03-01','Dokter Kampus','Dokter Kampus','Aktif','IT Del','M','Kontrak',0,'S1','S1','dokter kampus','dr',NULL,'dokter kampus','fidelis','2013-03-28 17:35:38','172.21.2.34',NULL,NULL,NULL),('22068811041201','Debora HF Hutagalung','Debora','Perempuan','Tarutung','1988-06-22','TK','2012-04-11','Staf','Staf','Keluar','IT Del','S','Kontrak',0,'S1','S1','staf',NULL,'S.Sos','Staf','fidelis','2012-04-13 09:14:48','172.21.3.76','gerry','2012-10-18 16:38:12','172.21.1.33'),('22069229081301','Batara Parada Siahaan','Batara','Laki-laki','Janji Maria','1992-06-22','TK','2013-08-29','Ass Dosen','Ass Dosen','Aktif','IT Del','S','Kontrak',0,'D3','D3','asisten dosen','','A.Md','asisten dosen','fidelis','2013-09-11 16:01:05','172.21.6.11',NULL,NULL,NULL),('220786031011','Heri Sitinjak','Heri','Laki-laki','Binjai','1986-07-22','TK','2011-10-03','Staf','Staf','Aktif','Yacab','L','Kontrak',NULL,'S1','S1',NULL,NULL,NULL,NULL,'gerry','2012-10-19 16:08:43','172.21.1.33','fidelis','2013-01-18 17:16:46','172.21.2.4'),('22089110091201','Hanna Theresia Lumbantobing','Hanna','Perempuan','Tarutung','1991-08-22','TK','2012-09-10','Ass Dosen','Ass Dosen','Keluar','IT Del','S','Kontrak',NULL,'D3','D3','Asdos',NULL,'A.Md','Asdos','fidelis','2012-10-12 11:51:12','172.21.2.253','fidelis','2013-09-19 11:43:35','172.21.6.11'),('22107901100101','Dongan Torang Pangaribuan','','Laki-laki','Sitoluama','1979-10-22','K-2','2001-10-01','Satpam','Satpam','Aktif','Yacab','M','Tetap',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:00:56','172.21.3.86','good','2011-04-01 11:27:32','172.23.2.145'),('22117701100101','Jaka Malela Napitupulu','','Laki-laki','Jakarta','1977-11-22','K-1','2001-10-01','Satpam','Satpam','Aktif','Yacab','L','Tetap',NULL,'SMP','SMP',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:04:07','172.21.3.86','good','2011-04-27 15:00:03','172.23.2.145'),('22126601100101','Ardin Siregar','','Laki-laki','Sigumpar','1966-12-22','K-3','2001-10-01','Taman','Taman','Aktif','Yacab','M','Tetap',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:02:13','172.21.3.86','good','2011-04-27 14:43:31','172.23.2.145'),('22128101020301','Tumpak Napitupulu','','Laki-laki','','1981-12-22','TK','2003-02-01','Satpam','Satpam','Aktif','Yacab','','Kontrak',NULL,'SMK','SMP',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:14:50','172.21.3.86','good','2011-04-27 15:29:27','172.23.2.145'),('23028714031101','Melva Herawati Simangunsong','Melva S','Perempuan','Binjai','1987-02-23','TK','2011-03-14','Full Timer Kemahasiswaan','Full Timer Kemahasiswaan','Keluar','IT Del','','Kontrak',NULL,'S1','S1',NULL,NULL,NULL,'Full Timer Kemahasiswaan','good','2011-04-01 20:58:36','172.21.3.127','fidelis','2014-07-02 14:24:51','172.21.2.2'),('23037802020901','Fernando Marpaung','','Laki-laki','Pekanbaru','1978-03-23','TK','2009-02-02','Satpam','Satpam','Aktif','Yacab','L','Kontrak',NULL,'SMK','SMK',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:22:38','172.21.3.86','good','2011-04-01 11:29:19','172.23.2.145'),('23048010110501','Henry Edison Sitorus','HES','Laki-laki','','1980-04-23','TK','2005-11-10','Dosen','Dosen','Keluar','IT Del','','Tetap',NULL,'S1','S2',NULL,NULL,NULL,NULL,'arya','2011-02-18 20:43:46','172.21.3.86','good','2011-03-18 15:04:16','172.23.2.244'),('23068904050901','Lasma Hotnida Fitri naiborhu','','Perempuan','Lumban Borhu','1989-06-23','TK','2009-05-04','Staf','Staf','Aktif','Yacab','L','Kontrak',NULL,'D1','D1',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:50:17','172.21.3.86','good','2011-04-27 15:04:16','172.23.2.145'),('23097211050901','Dohar Damanik','','Laki-laki','Medan','1972-09-23','K-1','2009-05-11','Pengemudi','Pengemudi','Aktif','Yacab','L','Kontrak',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:39:03','172.21.3.86','good','2011-04-27 14:52:10','172.23.2.145'),('23108702031101','Aris Suhendro Panjaitan','','Laki-laki','Metro','1987-10-23','TK','2011-03-02','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Keluar','IT Del','','Harian',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'good','2011-04-01 20:45:35','172.21.3.127','fidelis','2012-02-20 10:39:36','172.21.3.76'),('23118320030701','Elisa Margareth Sibarani','EMS','Perempuan','','1983-11-23','K-0','2007-03-20','Ass Dosen','Dosen','Aktif','IT Del','M','Tetap',NULL,'D3','S2',NULL,NULL,NULL,NULL,'arya','2011-02-18 20:58:16','172.21.3.86','good','2011-03-18 15:05:08','172.23.2.244'),('24028001021201','Hendriks Melki Hutapea','Hendriks','Laki-laki','Sigumpar','1980-02-24','K-1','2012-02-01','Staf','Staf','Aktif','Yacab','L','Kontrak',NULL,'S1','S1',NULL,NULL,NULL,NULL,'gerry','2012-10-19 16:15:23','172.21.1.33',NULL,NULL,NULL),('24058501031101','Riyanthi Angrainy Sianturi','RIS','Perempuan','Tarutung','1985-05-21','TK','2011-03-01','Dosen','Dosen','TSDP','IT Del','','Tetap',NULL,'S1','S1',NULL,NULL,NULL,NULL,'arya','2011-03-18 18:01:40','172.21.3.86','fidelis','2014-07-02 14:22:25','172.21.2.2'),('24097815111001','Arya Aditya','Arya','Laki-laki','','1978-09-24','TK','2010-11-15','Staf','Staf','Keluar','IT Del','XL','Kontrak',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'good','2011-04-01 12:03:06','172.23.2.145','togu','2012-02-20 11:19:26','172.21.251.124'),('24098920091001','Hernawati S.Samosir','HER','Perempuan','','1989-09-24','TK','2011-04-01','Duktek','Ass Dosen','Aktif','IT Del','','Tetap',NULL,'D3','D3','II/D',NULL,'Amd.','II/D','good','2011-04-01 13:31:35','172.23.2.145','fidelis','2014-07-04 17:00:35','172.21.2.2'),('24108220030701','Rosni R. Lumbantoruan','RSL','Perempuan','','1982-10-24','K-1','2007-03-20','Ass Dosen','Dosen','Aktif','IT Del','S','Tetap',NULL,'D3','S2',NULL,NULL,NULL,NULL,'arya','2011-02-18 21:02:33','172.21.3.86','fidelis','2014-07-02 14:01:23','172.21.2.2'),('24127324020301','Safar Manumpak Tua','','Laki-laki','Jakarta','1973-12-24','K-3','2003-02-24','Staf','Staf','Aktif','Yacab','L','Tetap',0,'','',NULL,NULL,'A.Md.',NULL,'arya','2011-02-18 22:45:19','172.21.3.86','gerry','2012-10-19 14:54:16','172.21.1.33'),('25028508080901','Hendriko Pasaribu','','Laki-laki','Haunatas','1985-02-25','TK','2009-08-08','CS','CS','Aktif','Yacab','L','Kontrak',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:23:57','172.21.3.86','good','2011-04-27 14:54:24','172.23.2.145'),('25029005091101','Masto Sitorus','Masto','Laki-laki','Balige','1990-02-25','TK','2011-09-05','Duktek','Duktek','Aktif','IT Del','','Tetap',NULL,'D3','D3','',NULL,'A.Md',NULL,'fidelis','2012-03-08 08:51:26','172.21.3.76','gerry','2012-10-18 16:29:35','172.21.1.33'),('25059005091101','Gerry Italiano Wowiling','Gerry','Laki-laki','Solo','1990-05-25','TK','2011-09-05','Duktek','Ass Dosen','TSDP','IT Del','L','Tetap',NULL,'D3','D3','','','A.Md','','fidelis','2012-03-07 09:12:09','172.21.3.76','fidelis','2014-07-02 14:25:50','172.21.2.2'),('25078715090801','Irma Sari Br Barus','Irma','Perempuan','','1987-07-25','TK','2008-09-15','Ass Dosen','Ass Dosen','Keluar','IT Del','','Kontrak',NULL,'D3','D3',NULL,NULL,NULL,NULL,'arya','2011-02-18 21:17:19','172.21.3.86','good','2011-03-18 15:07:24','172.23.2.244'),('25097301090201','Good Fried Panggabean','GFP','Laki-laki','Barus','1973-09-25','K-2','2002-09-01','Dosen','Dosen','TSDP','IT Del','XL','Tetap',NULL,'S1','S2',NULL,NULL,NULL,NULL,'arya','2011-02-18 20:19:57','172.21.3.86','fidelis','2014-07-04 17:01:51','172.21.2.2'),('25098702031101','Heri Setiawan Barutu','','Laki-laki','Rengat','2011-04-01','TK','2011-03-02','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Keluar','IT Del','','Harian',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'good','2011-04-01 20:48:28','172.21.3.127','fidelis','2012-02-20 10:44:48','172.21.3.76'),('25118711041101','Harry Nobenezer Tambunan','','Laki-laki','Kisaran Sei Alim','1987-11-25','TK','2011-04-11','Full Timer Kemahasiswaan','Full Timer Kemahasiswaan','Keluar','IT Del','','Kontrak',NULL,'S1','S1',NULL,NULL,NULL,NULL,'good','2011-04-27 14:16:25','172.23.2.145','fidelis','2012-02-20 10:34:07','172.21.3.76'),('26046401120301','Galege Pangaribuan','','Laki-laki','Pangaribuan','1964-04-26','K-5','2003-12-01','Taman','Taman','Aktif','Yacab','L','Kontrak',NULL,'SMA','SMA',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:27:12','172.21.3.86','good','2011-04-01 11:31:04','172.23.2.145'),('26048301020701','Humasak Tommy Argo Simanjuntak','HTS','Laki-laki','','1983-04-26','K-1','2007-02-01','Dosen','Dosen','Aktif','IT Del','M','Tetap',NULL,'D3','S1',NULL,NULL,NULL,NULL,'arya','2011-02-18 20:47:48','172.21.3.86','fidelis','2014-07-02 14:02:52','172.21.2.2'),('26048417090901','Frederik Bungaran Ishak Situmeang','FBS','Laki-laki','','1984-04-26','K-1','2009-09-17','Ass Dosen','Dosen','TSDP','IT Del','','Tetap',NULL,'D3','S2',NULL,NULL,NULL,NULL,'arya','2011-02-18 21:24:16','172.21.3.86','togu','2012-03-22 13:21:22','172.21.251.90'),('26068603011101','Junita Tarigan','','Perempuan','Kabanjahe','1986-06-26','TK','2011-01-03','Dokter Kampus','Dokter Kampus','Keluar','IT Del','','Kontrak',NULL,'S1','S1',NULL,NULL,NULL,NULL,'good','2011-04-27 13:49:53','172.23.2.145','gerry','2012-10-18 16:28:37','172.21.1.33'),('26069229081301','Olga Minar Viona Sianturi','Olga','Perempuan','Pematangsiantar ','1992-06-26','TK','2013-08-29','Ass Dosen','Ass Dosen','Aktif','IT Del','S','Kontrak',0,'D3','D3','Asisten Dosen',NULL,'A.Md','Asisten Dosen','fidelis','2013-09-11 16:07:40','172.21.6.11',NULL,NULL,NULL),('270280190913','Arie  Satia Dharma','Arie','Laki-laki','Palembang ','1980-02-27','K-1','2013-09-19','Ass Dosen','Ass Dosen','Aktif','IT Del','XL','Kontrak',0,'S1','','Asisten Dosen',NULL,'ST','Asisten Dosen','fidelis','2013-09-19 11:37:30','172.21.6.11',NULL,NULL,NULL),('27049012011101','Yoke Aprillia Purba','Yoke','Perempuan','Medan','1990-04-27','TK','2012-01-12','Staf','Staf','Aktif','IT Del','S','Kontrak',0,'D3','D3',NULL,NULL,'A.Md',NULL,'fidelis','2012-03-08 09:47:50','172.21.3.76',NULL,NULL,NULL),('27058303041201','Melva Sabar Maria Hutagalung','Melva H','Perempuan','Medan','1983-05-27','TK','2012-04-03','Staf','Staf','Aktif','IT Del','M','Kontrak',0,'S1','S1','staf','','S.Sos','staf','fidelis','2012-04-13 08:56:33','172.21.3.76',NULL,NULL,NULL),('27068906031201','Mini Indah Simamora','Mini','Perempuan','Hutajulu','1989-06-27','TK','2012-03-06','Asisten Bapak/Ibu Asrama ','Asisten Bapak/Ibu Asrama ','Keluar','IT Del','S','Harian',NULL,'S1','S1',NULL,NULL,NULL,NULL,'fidelis','2012-03-08 10:30:50','172.21.3.76','fidelis','2013-01-18 17:15:16','172.21.2.4'),('27076501090501','Richard Butar-Butar','','Laki-laki','Medan','1965-07-27','K-3','2005-09-01','Taman','Taman','Aktif','Yacab','L','Tetap',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:29:09','172.21.3.86','good','2011-04-27 15:18:33','172.23.2.145'),('27077621101101','Silvia Yulianti','Silvia','Perempuan','Jakarta','0000-00-00','K-1','2011-10-21','Staf','Staf','Keluar','IT Del','L','Harian',0,'D3','D3',NULL,NULL,'A.Md',NULL,'fidelis','2012-03-08 10:51:33','172.21.3.76','fidelis','2013-09-19 11:42:09','172.21.6.11'),('27087014040301','Palty Pangaribuan','','Laki-laki','','1970-08-27','K-2','2003-04-14','Maintenance','Maintenance','Aktif','Yacab','L','Tetap',0,'S1','S1',NULL,NULL,NULL,NULL,'arya','2011-02-18 22:29:43','172.21.3.86','good','2011-04-27 15:11:04','172.23.2.145'),('27107606050401','Panti Arno Hutapea','','Laki-laki','','1976-10-27','K-2','2004-05-06','CS','CS','Aktif','Yacab','','Tetap',NULL,'','',NULL,NULL,NULL,NULL,'arya','2011-02-18 23:19:45','172.21.3.86','good','2011-04-27 15:13:21','172.23.2.145'),('28058801100901','Mario Elyezer Subekti Simaremare','MSS','Laki-laki','','1988-05-28','TK','2009-10-01','Ass Dosen','Ass Dosen','Aktif','IT Del','','Tetap',NULL,'D3','D3','II/D',NULL,'Amd.','II/D','good','2011-04-01 13:49:24','172.23.2.145','fidelis','2014-07-04 17:00:18','172.21.2.2'),('29017617101101','Erika Pasaribu','Erika','Perempuan','Balige','1976-01-29','TK','2011-10-17','Staf','Staf','Keluar','Yacab','M','Kontrak',NULL,'','S1',NULL,NULL,NULL,NULL,'gerry','2012-10-19 16:10:51','172.21.1.33','fidelis','2014-07-02 14:28:32','172.21.2.2'),('29018519041001','Suryadi Wirawan','','Laki-laki','Makassar','1985-01-29','TK','2010-04-19','Dokter Kampus','Dokter Kampus','Keluar','IT Del','','Kontrak',NULL,'S1','S1',NULL,NULL,NULL,NULL,'good','2011-04-27 13:55:53','172.23.2.145','fidelis','2012-02-20 11:03:43','172.21.3.76'),('29078921101301','Osin Verawati Nainggolan','Osin ','Perempuan','Medan','1989-07-29','TK','2013-10-21','Staf','Staf','Aktif','IT Del','S','Kontrak',0,'S1','S1','staf',NULL,'S.Sos','Staf ','fidelis','2013-10-22 08:23:20','172.21.6.11',NULL,NULL,NULL),('29084418070101','Patuan P. Simatupang','PPS','Laki-laki','','1944-08-29','K-2','2001-07-18','Ketua Pengurus Yayasan Del (pusat)','Ketua Pengurus Yayasan Del (pusat)','Aktif','Yapus','','Tetap',NULL,'S2','S2','Ketua Pengurus Yayasan Del (pusat)','Ir.','MCRP',NULL,NULL,NULL,NULL,'inte','2011-04-20 17:44:25','172.21.3.7'),('29098920091001','Togu N. Turnip','TNT','Laki-laki','','1989-11-29','TK','2010-09-20','Ass Dosen','Ass Dosen','Aktif','IT Del','','Tetap',NULL,'D3','D3','II/D',NULL,'Amd.','asisten Dosen','good','2011-04-01 13:35:05','172.23.2.145','fidelis','2014-07-02 14:23:56','172.21.2.2'),('30047201111001','Fidelis Haposan Silalahi','FHS','Laki-laki','','1972-04-30','K-3','2010-11-01','Staf','Staf','Aktif','IT Del','L','Tetap',NULL,'S1','S1',NULL,NULL,'S.H.',NULL,'good','2011-04-01 11:55:59','172.23.2.145','fidelis','2013-01-18 16:57:26','172.21.2.4'),('30047631011101','Francis Panjaitan','Francis','Laki-laki','Siantar','1976-04-30','K-2','2011-01-31','CS','CS','Aktif','Yacab','L','Kontrak',NULL,'D3','D3',NULL,NULL,NULL,NULL,'gerry','2012-10-19 15:57:37','172.21.1.33','gerry','2012-10-19 16:02:00','172.21.1.33'),('30047812080201','Ramot Lubis','RML','Laki-laki','','1978-04-30','K-1','2002-08-12','Dosen','Dosen','Keluar','IT Del','M','Tetap',NULL,'S1','S2',NULL,NULL,NULL,NULL,'arya','2011-02-18 20:13:34','172.21.3.86','inte','2012-01-18 15:48:44','172.23.2.14'),('30058517098501','Parmonangan Rotua Togatorop','Mona','Perempuan','Laguboti ','1985-05-30','TK','2013-09-17','Ass Dosen','Ass Dosen','Aktif','IT Del','S','Kontrak',0,'S1','S1','Asisten Dosen',NULL,'A.Md','Asisten Dosen','fidelis','2013-09-19 11:34:31','172.21.6.11','fidelis','2014-07-02 14:41:43','172.21.2.2'),('8888888','Blank','Blank','Laki-laki','Blank','2014-08-18','TK','2014-08-18','Blank','Blank','Aktif','IT Del','S','Tetap',79,'SMP','SMP','Blank','Blank','Blank','Blank','76','2014-08-18 10:27:02','127.0.0.1',NULL,NULL,NULL),('9999999','Testing','TES','Laki-laki','Testing','2014-08-01','TK','2014-08-19','Testing','Testing','Aktif','IT Del','S','Tetap',79,'D3','S1','Testing','Testing','Testing','Testing','76','2014-08-18 09:17:40','127.0.0.1',NULL,NULL,NULL);

/*Table structure for table `hrd_m_staf` */

DROP TABLE IF EXISTS `hrd_m_staf`;

CREATE TABLE `hrd_m_staf` (
  `staff_id` int(11) NOT NULL AUTO_INCREMENT,
  `nip` varchar(45) DEFAULT NULL,
  `unit_kerja` varchar(45) DEFAULT NULL,
  `golongan_now` varchar(45) DEFAULT NULL,
  `sejarah_golongan` varchar(200) DEFAULT NULL,
  `created_by` varchar(200) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `created_ip` varchar(15) DEFAULT NULL,
  `updated_by` varchar(200) DEFAULT NULL,
  `updated_date` datetime DEFAULT NULL,
  `updated_ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`staff_id`),
  KEY `FK_hrd_m_staf` (`nip`),
  CONSTRAINT `FK_hrd_m_staf` FOREIGN KEY (`nip`) REFERENCES `hrd_m_pegawai` (`nip`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

/*Data for the table `hrd_m_staf` */

insert  into `hrd_m_staf`(`staff_id`,`nip`,`unit_kerja`,`golongan_now`,`sejarah_golongan`,`created_by`,`created_date`,`created_ip`,`updated_by`,`updated_date`,`updated_ip`) values (1,'01017406100801','Cleaning Service','Cleaning Service','Cleaning Service','76','2014-08-18 09:02:48','127.0.0.1',NULL,NULL,NULL),(4,'22068301031301','Dokter Kampus','Dokter Kampus','Dokter Kampus','76','2014-08-18 09:24:58','127.0.0.1',NULL,NULL,NULL),(5,'0305140109','Abang Kakak Asrama','Abang Kakak Asrama','Abang Kakak Asrama','76','2014-08-18 09:25:39','127.0.0.1',NULL,NULL,NULL),(6,'17048809071201','LPPM','LPPM','LPPM','76','2014-08-18 10:46:03','127.0.0.1',NULL,NULL,NULL);

/*Table structure for table `hrd_r_status` */

DROP TABLE IF EXISTS `hrd_r_status`;

CREATE TABLE `hrd_r_status` (
  `status_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id status',
  `status` varchar(255) NOT NULL COMMENT 'keterangan status',
  `created_by` varchar(255) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_ip` varchar(15) DEFAULT NULL,
  `updated_by` varchar(255) DEFAULT NULL,
  `updated_date` date DEFAULT NULL,
  `updated_ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

/*Data for the table `hrd_r_status` */

insert  into `hrd_r_status`(`status_id`,`status`,`created_by`,`created_date`,`created_ip`,`updated_by`,`updated_date`,`updated_ip`) values (1,'Waiting for approval',NULL,NULL,NULL,NULL,NULL,NULL),(2,'Approved',NULL,NULL,NULL,NULL,NULL,NULL),(3,'Rejected',NULL,NULL,NULL,NULL,NULL,NULL),(4,'Released',NULL,NULL,NULL,NULL,NULL,NULL),(5,'Reported',NULL,NULL,NULL,NULL,NULL,NULL),(6,'Closed',NULL,NULL,NULL,NULL,NULL,NULL);

/*Table structure for table `hrd_t_kehadiran` */

DROP TABLE IF EXISTS `hrd_t_kehadiran`;

CREATE TABLE `hrd_t_kehadiran` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nip_hrd_pegawai` varchar(45) NOT NULL,
  `no_badge` varchar(10) NOT NULL,
  `tgl_hadir` date NOT NULL,
  `jam_datang` time NOT NULL,
  `jam_pulang` time NOT NULL,
  `created_by` varchar(200) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `created_ip` varchar(15) DEFAULT NULL,
  `updated_by` varchar(200) DEFAULT NULL,
  `updated_date` datetime DEFAULT NULL,
  `updated_ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_hrd_t_kehadiran` (`nip_hrd_pegawai`),
  CONSTRAINT `FK_hrd_t_kehadiran` FOREIGN KEY (`nip_hrd_pegawai`) REFERENCES `hrd_m_pegawai` (`nip`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `hrd_t_kehadiran` */

/*Table structure for table `hrd_t_report_duty_letter` */

DROP TABLE IF EXISTS `hrd_t_report_duty_letter`;

CREATE TABLE `hrd_t_report_duty_letter` (
  `report_duty_letter_id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id laporan surat tugas',
  `duty_letter_id` int(10) NOT NULL COMMENT 'id surat tugas',
  `report_date` date NOT NULL COMMENT 'tanggal laporan',
  `report_file_name` varchar(100) DEFAULT NULL COMMENT 'nama file laporan',
  `created_by` varchar(200) DEFAULT NULL,
  `created_ip` varchar(15) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `updated_ip` varchar(15) DEFAULT NULL,
  `updated_by` varchar(200) DEFAULT NULL,
  `updated_date` date DEFAULT NULL,
  PRIMARY KEY (`report_duty_letter_id`),
  KEY `duty_letter_id` (`duty_letter_id`),
  CONSTRAINT `FK_hrd_t_report_duty_letter` FOREIGN KEY (`duty_letter_id`) REFERENCES `hrd_m_duty_letter` (`duty_letter_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `hrd_t_report_duty_letter` */

/*Table structure for table `hrd_t_request_duty_letter` */

DROP TABLE IF EXISTS `hrd_t_request_duty_letter`;

CREATE TABLE `hrd_t_request_duty_letter` (
  `rdl_id` int(11) NOT NULL AUTO_INCREMENT,
  `requester_id` varchar(45) NOT NULL,
  `duty_category` varchar(200) NOT NULL,
  `duty_concerning` varchar(200) NOT NULL,
  `duty_location` varchar(200) NOT NULL,
  `contactable_information` varchar(200) NOT NULL,
  `depart_date` date NOT NULL,
  `return_date` date NOT NULL,
  `starting_date` date NOT NULL,
  `finishing_date` date NOT NULL,
  `status_id` int(11) NOT NULL,
  `request_date` date DEFAULT NULL,
  `response_date` date DEFAULT NULL,
  `rejection_reason` text,
  `created_by` varchar(200) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `created_ip` varchar(15) DEFAULT NULL,
  `updated_by` varchar(200) DEFAULT NULL,
  `updated_date` datetime DEFAULT NULL,
  `updated_ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`rdl_id`),
  KEY `requester_id` (`requester_id`),
  KEY `status_id` (`status_id`),
  CONSTRAINT `FK_hrd_t_request_duty_letter_status` FOREIGN KEY (`status_id`) REFERENCES `hrd_r_status` (`status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;

/*Data for the table `hrd_t_request_duty_letter` */

insert  into `hrd_t_request_duty_letter`(`rdl_id`,`requester_id`,`duty_category`,`duty_concerning`,`duty_location`,`contactable_information`,`depart_date`,`return_date`,`starting_date`,`finishing_date`,`status_id`,`request_date`,`response_date`,`rejection_reason`,`created_by`,`created_date`,`created_ip`,`updated_by`,`updated_date`,`updated_ip`) values (1,'1','test aja','test aja','test aja','test aja','2013-09-05','2013-09-12','2013-09-05','2013-09-12',2,'2013-09-04','2013-09-05',NULL,'1','2013-09-04 14:38:26','127.0.0.1','1','2013-09-05 21:39:00','127.0.0.1'),(2,'2','test aja2','test aja2','test aja2','test aja2','2013-09-05','2013-09-12','2013-09-05','2013-09-12',2,'2013-09-04','2013-09-05',NULL,'1','2013-09-04 14:44:04','127.0.0.1','1','2013-09-05 09:43:41','127.0.0.1'),(3,'5','test aja3','test aja3','test aja3','test aja3','2013-09-05','2013-09-12','2013-09-05','2013-09-12',2,'2013-09-04','2013-09-05',NULL,'1','2013-09-04 14:48:28','127.0.0.1','1','2013-09-05 13:49:49','127.0.0.1'),(4,'1','test aja','test aja','test aja','test aja','2013-09-05','2013-09-12','2013-09-05','2013-09-12',2,'2013-09-05','2013-09-05',NULL,'1','2013-09-05 13:54:50','127.0.0.1','1','2013-09-05 13:56:23','127.0.0.1'),(5,'1','test aja','test aja','test aja','test aja','2013-09-05','2013-09-12','2013-09-05','2013-09-12',2,'2013-09-05','2013-09-05',NULL,'1','2013-09-05 13:54:56','127.0.0.1','1','2013-09-05 13:58:49','127.0.0.1'),(6,'1','test aja','test aja','test aja','test aja','2013-09-05','2013-09-12','2013-09-05','2013-09-12',2,'2013-09-05','2013-09-05',NULL,'1','2013-09-05 13:55:29','127.0.0.1','1','2013-09-05 14:00:26','127.0.0.1'),(7,'1','test aja','test aja','test aja','test aja','2013-09-05','2013-09-12','2013-09-05','2013-09-12',3,'2013-09-05','2013-09-05','test','1','2013-09-05 14:02:32','127.0.0.1','1','2013-09-05 15:37:38','127.0.0.1'),(8,'1','test aja','test aja','test aja','test aja','2013-09-05','2013-09-12','2013-09-05','2013-09-12',3,'2013-09-05','2013-09-05','test lagi....','1','2013-09-05 14:02:36','127.0.0.1','1','2013-09-05 16:10:16','127.0.0.1'),(9,'1','test aja','test aja','test aja','test aja','2013-09-05','2013-09-12','2013-09-05','2013-09-12',2,'2013-09-05','2013-09-05',NULL,'1','2013-09-05 15:11:21','127.0.0.1','1','2013-09-05 22:47:45','127.0.0.1'),(10,'1','test aja','test aja','test aja','test aja','2013-09-05','2013-09-12','2013-09-05','2013-09-12',3,'2013-09-05','2013-09-19','test','1','2013-09-05 22:17:38','127.0.0.1','1','2013-09-19 11:12:51','127.0.0.1'),(11,'1','test aja','test aja','test aja','test aja','2013-09-05','2013-09-12','2013-09-05','2013-09-12',3,'2013-09-05','2013-09-19','test','1','2013-09-05 22:29:29','127.0.0.1','1','2013-09-19 11:11:36','127.0.0.1'),(12,'1','test aja','test aja','test aja','test aja','2013-09-05','2013-09-12','2013-09-05','2013-09-12',2,'2013-09-05','2013-09-18',NULL,'1','2013-09-05 23:03:30','127.0.0.1','1','2013-09-18 18:17:53','127.0.0.1'),(13,'2','test aja','test aja','test aja','test aja','2013-09-05','2013-09-12','2013-09-05','2013-09-12',2,'2013-09-05','2013-09-11',NULL,'1','2013-09-05 23:29:15','127.0.0.1','1','2013-09-11 11:16:47','127.0.0.1'),(14,'3','test aja','test aja','test aja','test aja','2013-09-12','2013-09-19','2013-09-12','2013-09-19',2,'2013-09-11','2013-09-11',NULL,'1','2013-09-11 10:41:33','127.0.0.1','1','2013-09-11 10:45:33','127.0.0.1'),(15,'3','test','test','test','test','2013-09-20','2013-09-21','2013-09-20','2013-09-21',2,'2013-09-19','2013-09-19',NULL,'1','2013-09-19 10:54:08','127.0.0.1','1','2013-09-19 10:57:15','127.0.0.1'),(16,'2','test','test','test','test','2013-09-19','2013-09-19','2013-09-19','2013-09-19',2,'2013-09-19','2013-09-19',NULL,'1','2013-09-19 13:19:48','127.0.0.1','1','2013-09-19 15:47:04','127.0.0.1'),(17,'1','rr','rr','rr','rr','2014-07-01','2014-07-02','2014-07-04','2014-07-26',2,'2014-07-01','2014-07-01',NULL,'40','2014-07-01 13:06:28','127.0.0.1','40','2014-07-01 14:10:07','127.0.0.1'),(19,'1','test','test','test','test','2014-08-14','2014-08-26','2014-08-21','2014-08-29',1,'2014-08-06',NULL,NULL,'76','2014-08-06 20:32:56','::1',NULL,NULL,NULL),(20,'2','test','test','test','test','2014-08-12','2014-08-13','2014-08-27','2014-08-28',1,'2014-08-10',NULL,NULL,'76','2014-08-10 17:19:41','::1',NULL,NULL,NULL);

/*Table structure for table `sys_m_controller` */

DROP TABLE IF EXISTS `sys_m_controller`;

CREATE TABLE `sys_m_controller` (
  `sys_m_controller_id` varchar(100) NOT NULL,
  `sys_m_module_id` varchar(100) NOT NULL,
  `desc` tinytext,
  `ucrea` varchar(70) DEFAULT NULL,
  `dcrea` timestamp NULL DEFAULT NULL,
  `icrea` varchar(45) DEFAULT NULL,
  `uupd` varchar(70) DEFAULT NULL,
  `dupd` timestamp NULL DEFAULT NULL,
  `iupd` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`sys_m_controller_id`),
  KEY `fk_controller_modul1_idx` (`sys_m_module_id`),
  CONSTRAINT `fk_controller_modul1` FOREIGN KEY (`sys_m_module_id`) REFERENCES `sys_m_module` (`sys_m_module_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `sys_m_controller` */

insert  into `sys_m_controller`(`sys_m_controller_id`,`sys_m_module_id`,`desc`,`ucrea`,`dcrea`,`icrea`,`uupd`,`dupd`,`iupd`) values ('AppModule','rbac','App Module controller','admin','2014-07-22 11:09:00',NULL,NULL,NULL,NULL),('HrdDPegawai','sdm','Hrd Detail Pegawai','admin','2012-07-13 08:57:46',NULL,NULL,NULL,NULL),('HrdHRequestDutyLetter','surat_tugas','Request duty letter','admin','2014-07-22 14:12:28',NULL,NULL,NULL,NULL),('HrdHRiwayatPendidikan','sdm','Hrd H Riwayat Pendidikan','admin','2012-07-13 08:58:45',NULL,NULL,NULL,NULL),('HrdHRiwayatPengajaran','sdm','Hrd H Riwayat Pengajaran','admin','2012-07-13 08:59:08',NULL,NULL,NULL,NULL),('HrdMDosen','sdm','Hrd Master Dosen','admin','2012-07-13 08:59:27',NULL,'admin','2012-07-13 09:00:35',NULL),('HrdMDutyLetter','surat_tugas','Hrd Master Duty Letter','admin','2014-07-22 14:12:51',NULL,NULL,NULL,NULL),('HrdMPegawai','sdm','Hrd Master Pegawai','admin','2012-07-13 08:59:54',NULL,NULL,NULL,NULL),('HrdMStaf','sdm','Hrd Master Staf','admin','2012-07-13 09:00:14',NULL,NULL,NULL,NULL),('HrdRStatus','surat_tugas','Hrd R Status','admin','2014-07-22 14:13:10',NULL,NULL,NULL,NULL),('HrdTReportDutyLetter','surat_tugas','Hrd T Report Duty Letter','admin','2014-07-22 14:13:27',NULL,'admin','2014-07-22 14:14:27',NULL),('HrdTRequestDutyLetter','surat_tugas','Hrd T Request Duty Letter','admin','2014-07-22 14:13:48',NULL,NULL,NULL,NULL),('Imap','rbac','Imap controller','admin','2014-07-22 11:07:57',NULL,NULL,NULL,NULL),('Privilage','rbac','Privilage controller','admin','2014-07-22 11:07:40',NULL,NULL,NULL,NULL),('Role','rbac','Role controller','admin','2014-07-22 11:07:26',NULL,NULL,NULL,NULL),('RolePrivilage','rbac','Role privilage controller','admin','2014-07-22 11:07:11',NULL,NULL,NULL,NULL),('User','rbac','User controller','admin','2014-07-22 11:06:51',NULL,NULL,NULL,NULL),('UserRole','rbac','User role controller','admin','2014-07-22 11:06:35',NULL,NULL,NULL,NULL);

/*Table structure for table `sys_m_imap` */

DROP TABLE IF EXISTS `sys_m_imap`;

CREATE TABLE `sys_m_imap` (
  `sys_m_imap_id` smallint(2) NOT NULL AUTO_INCREMENT,
  `sys_m_imap_host` varchar(30) NOT NULL,
  `sys_m_imap_name` varchar(25) NOT NULL,
  `sys_m_imap_port` varchar(20) NOT NULL,
  `max_tries_to_login` tinyint(4) NOT NULL,
  `max_bann_time` int(11) NOT NULL,
  `created_date` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_ip` varchar(30) DEFAULT NULL,
  `modified_date` datetime DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `modified_ip` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`sys_m_imap_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

/*Data for the table `sys_m_imap` */

insert  into `sys_m_imap`(`sys_m_imap_id`,`sys_m_imap_host`,`sys_m_imap_name`,`sys_m_imap_port`,`max_tries_to_login`,`max_bann_time`,`created_date`,`created_by`,`created_ip`,`modified_date`,`modified_by`,`modified_ip`) values (1,'students.del.ac.id','students.del.ac.id','143/imap',3,10,NULL,NULL,NULL,NULL,NULL,NULL),(2,'mail.del.ac.id','del.ac.id','143/imap',3,10,NULL,NULL,NULL,NULL,NULL,NULL);

/*Table structure for table `sys_m_module` */

DROP TABLE IF EXISTS `sys_m_module`;

CREATE TABLE `sys_m_module` (
  `sys_m_module_id` varchar(100) NOT NULL,
  `desc` text,
  `ucrea` varchar(70) DEFAULT NULL,
  `dcrea` timestamp NULL DEFAULT NULL,
  `icrea` varchar(45) DEFAULT NULL,
  `uupd` varchar(70) DEFAULT NULL,
  `dupd` timestamp NULL DEFAULT NULL,
  `iupd` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`sys_m_module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `sys_m_module` */

insert  into `sys_m_module`(`sys_m_module_id`,`desc`,`ucrea`,`dcrea`,`icrea`,`uupd`,`dupd`,`iupd`) values ('rbac','Role Based Access Control','admin','2012-07-13 08:55:50',NULL,NULL,NULL,NULL),('sdm','Sumber Daya Manusia','admin','2012-07-13 08:52:41',NULL,NULL,NULL,NULL),('site','Site Controller','admin','2012-07-13 08:56:38',NULL,NULL,NULL,NULL),('surat_tugas','Surat Tugas','admin','2014-07-22 14:11:51',NULL,NULL,NULL,NULL);

/*Table structure for table `sys_m_privilage` */

DROP TABLE IF EXISTS `sys_m_privilage`;

CREATE TABLE `sys_m_privilage` (
  `sys_m_privilage_id` int(11) NOT NULL AUTO_INCREMENT,
  `sys_m_module_id` varchar(100) NOT NULL,
  `sys_m_controller_id` varchar(100) NOT NULL,
  `action` varchar(100) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `desc` tinytext,
  `ucrea` varchar(70) DEFAULT NULL,
  `dcrea` timestamp NULL DEFAULT NULL,
  `icrea` varchar(45) DEFAULT NULL,
  `uupd` varchar(70) DEFAULT NULL,
  `dupd` timestamp NULL DEFAULT NULL,
  `iupd` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`sys_m_privilage_id`),
  KEY `fk_privilage_module1_idx` (`sys_m_module_id`),
  KEY `fk_privilage_controller1_idx` (`sys_m_controller_id`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=latin1;

/*Data for the table `sys_m_privilage` */

insert  into `sys_m_privilage`(`sys_m_privilage_id`,`sys_m_module_id`,`sys_m_controller_id`,`action`,`name`,`desc`,`ucrea`,`dcrea`,`icrea`,`uupd`,`dupd`,`iupd`) values (53,'sdm','HrdMDosen','index','sdm-HrdMDosen-index','Index of Master Dosen','admin','2012-07-13 09:07:30',NULL,NULL,NULL,NULL),(54,'sdm','HrdMStaf','index','sdm-HrdMStaf-index','Index Of Master Staff','admin','2012-07-13 09:07:52',NULL,NULL,NULL,NULL),(55,'sdm','HrdMDosen','admin','sdm-HrdMDosen-admin','Admin of Master Dosen','admin','2014-07-22 10:41:24',NULL,NULL,NULL,NULL),(56,'sdm','HrdMStaf','admin','sdm-HrdMStaf-admin','Admin of Master staf','admin','2014-07-22 10:41:54',NULL,NULL,NULL,NULL),(57,'surat_tugas','HrdHRequestDutyLetter','admin','surat_tugas-HrdHRequestDutyLetter-admin','Admin of request duty letter','admin','2014-07-22 14:29:04',NULL,NULL,NULL,NULL),(58,'surat_tugas','HrdMDutyLetter','admin','surat_tugas-HrdMDutyLetter-admin','Admin of Hrd master duty letter','admin','2014-07-22 14:29:26',NULL,NULL,NULL,NULL),(59,'surat_tugas','HrdRStatus','admin','surat_tugas-HrdRStatus-admin','Admin of hrd r status','admin','2014-07-22 14:29:46',NULL,NULL,NULL,NULL),(60,'surat_tugas','HrdTReportDutyLetter','admin','surat_tugas-HrdTReportDutyLetter-admin','Admin of hrd t report duty letter','admin','2014-07-22 14:30:05',NULL,NULL,NULL,NULL),(61,'surat_tugas','HrdTRequestDutyLetter','admin','surat_tugas-HrdTRequestDutyLetter-admin','admin of hrd t request duty letter','admin','2014-07-22 14:30:24',NULL,NULL,NULL,NULL),(62,'surat_tugas','HrdTReportDutyLetter','Create','surat_tugas-HrdTReportDutyLetter-Create','Create report duty Letter','admin','2014-07-25 14:35:54',NULL,NULL,NULL,NULL),(63,'surat_tugas','HrdTRequestDutyLetter','index','surat_tugas-HrdTRequestDutyLetter-index','Index of Hrd t request duty letter','admin','2014-07-25 14:54:35',NULL,NULL,NULL,NULL),(64,'surat_tugas','HrdTRequestDutyLetter','Create','surat_tugas-HrdTRequestDutyLetter-Create','Create t request duty letter','admin','2014-07-25 15:23:04',NULL,NULL,NULL,NULL),(65,'sdm','HrdMPegawai','Create','sdm-HrdMPegawai-Create','Create Hrd M Pegawai','admin','2014-08-06 20:56:45',NULL,NULL,NULL,NULL),(66,'sdm','HrdMPegawai','View','sdm-HrdMPegawai-View','View Hrd M Pegawai','admin','2014-08-06 20:57:13',NULL,NULL,NULL,NULL),(67,'sdm','HrdDPegawai','Create','sdm-HrdDPegawai-Create','Create Hrd D Pegawai','admin','2014-08-06 20:57:49',NULL,NULL,NULL,NULL),(68,'sdm','HrdDPegawai','View','sdm-HrdDPegawai-View','View Hrd D Pegawai','admin','2014-08-06 20:58:16',NULL,NULL,NULL,NULL),(69,'sdm','HrdMStaf','Create','sdm-HrdMStaf-Create','Create Hrd M Staf','admin','2014-08-06 20:58:43',NULL,NULL,NULL,NULL),(70,'sdm','HrdMStaf','View','sdm-HrdMStaf-View','View Hrd M Staf','admin','2014-08-06 20:59:13',NULL,NULL,NULL,NULL),(71,'sdm','HrdMDosen','Create','sdm-HrdMDosen-Create','Create Hrd M Dosen','admin','2014-08-06 21:58:48',NULL,NULL,NULL,NULL),(72,'sdm','HrdMDosen','View','sdm-HrdMDosen-View','View Hrd M Dosen','admin','2014-08-06 21:59:20',NULL,NULL,NULL,NULL),(73,'sdm','HrdMPegawai','Admin','sdm-HrdMPegawai-Admin','Admin Hrd M Pegawai','admin','2014-08-06 22:11:21',NULL,NULL,NULL,NULL),(74,'sdm','HrdDPegawai','Admin','sdm-HrdDPegawai-Admin','Admin Hrd D Pegawai','admin','2014-08-06 22:11:49',NULL,NULL,NULL,NULL),(75,'sdm','HrdHRiwayatPendidikan','Admin','sdm-HrdHRiwayatPendidikan-Admin','Admin Hrd H Riwayat Pendidikan','admin','2014-08-10 15:16:30',NULL,NULL,NULL,NULL),(76,'sdm','HrdHRiwayatPendidikan','Create','sdm-HrdHRiwayatPendidikan-Create','Create Hrd H Riwayat Pendidikan','admin','2014-08-10 15:17:01',NULL,NULL,NULL,NULL),(77,'sdm','HrdHRiwayatPendidikan','View','sdm-HrdHRiwayatPendidikan-View','View Hrd H Riwayat Pendidikan','admin','2014-08-10 15:17:29',NULL,NULL,NULL,NULL),(78,'sdm','HrdHRiwayatPengajaran','Admin','sdm-HrdHRiwayatPengajaran-Admin','Admin Hrd H Riwayat Pengajaran','admin','2014-08-10 15:17:56',NULL,NULL,NULL,NULL),(79,'sdm','HrdHRiwayatPengajaran','Create','sdm-HrdHRiwayatPengajaran-Create','Create Hrd H Riwayat Pengajaran','admin','2014-08-10 15:18:26',NULL,NULL,NULL,NULL),(80,'sdm','HrdHRiwayatPengajaran','View','sdm-HrdHRiwayatPengajaran-View','View Hrd H Riwayat Pengajaran','admin','2014-08-10 15:18:55',NULL,NULL,NULL,NULL),(81,'sdm','HrdMPegawai','Update','sdm-HrdMPegawai-Update','','admin','2014-08-12 16:54:12',NULL,NULL,NULL,NULL),(82,'sdm','HrdMPegawai','Delete','sdm-HrdMPegawai-Delete','','admin','2014-08-12 16:54:50',NULL,NULL,NULL,NULL),(83,'sdm','HrdMPegawai','Index','sdm-HrdMPegawai-Index','','admin','2014-08-12 16:55:54',NULL,NULL,NULL,NULL);

/*Table structure for table `sys_m_role` */

DROP TABLE IF EXISTS `sys_m_role`;

CREATE TABLE `sys_m_role` (
  `sys_m_role_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `desc` tinytext,
  `ucrea` varchar(70) DEFAULT NULL,
  `dcrea` timestamp NULL DEFAULT NULL,
  `icrea` varchar(45) DEFAULT NULL,
  `uupd` varchar(70) DEFAULT NULL,
  `dupd` timestamp NULL DEFAULT NULL,
  `iupd` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`sys_m_role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

/*Data for the table `sys_m_role` */

insert  into `sys_m_role`(`sys_m_role_id`,`name`,`desc`,`ucrea`,`dcrea`,`icrea`,`uupd`,`dupd`,`iupd`) values (1,'admin','admin',NULL,NULL,NULL,'budi','2013-06-08 04:43:52',NULL),(2,'dosen','dosen',NULL,NULL,NULL,NULL,NULL,NULL),(3,'guest','guest',NULL,NULL,NULL,'budi','2013-06-09 15:20:28',NULL),(4,'mahasiswa','mahasiswa',NULL,NULL,NULL,NULL,NULL,NULL),(5,'staff','staff ','budi','2013-09-03 17:35:16',NULL,NULL,NULL,NULL);

/*Table structure for table `sys_m_user` */

DROP TABLE IF EXISTS `sys_m_user`;

CREATE TABLE `sys_m_user` (
  `sys_m_user_id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `login_type` tinyint(4) DEFAULT '0' COMMENT '0=imap;1=DB',
  `last_login` datetime DEFAULT NULL,
  `n_tries` tinyint(4) DEFAULT '0',
  `last_try` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `dcrea` timestamp NULL DEFAULT NULL,
  `ucrea` varchar(70) DEFAULT NULL,
  `uupd` varchar(70) DEFAULT NULL,
  `dupd` timestamp NULL DEFAULT NULL,
  `icrea` varchar(45) DEFAULT NULL,
  `iupd` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`sys_m_user_id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=latin1;

/*Data for the table `sys_m_user` */

insert  into `sys_m_user`(`sys_m_user_id`,`username`,`password`,`email`,`login_type`,`last_login`,`n_tries`,`last_try`,`status`,`dcrea`,`ucrea`,`uupd`,`dupd`,`icrea`,`iupd`) values (76,'admin','21232f297a57a5a743894a0e4a801fc3','admin@del.ac.id',1,NULL,0,NULL,1,'2012-07-13 09:01:43','admin',NULL,NULL,NULL,NULL),(77,'dosen','ce28eed1511f631af6b2a7bb0a85d636','dosen@del.ac.id',1,NULL,0,NULL,1,'2012-07-13 09:03:37','admin',NULL,NULL,NULL,NULL),(78,'guest','084e0343a0486ff05530df6c705c8bb4','guest@del.ac.id',1,NULL,0,NULL,1,'2012-07-13 09:03:55','admin',NULL,NULL,NULL,NULL),(79,'staf','7b8a17c3f48d4453fde0fd74b4fa9212','staf@del.ac.id',1,NULL,0,NULL,1,'2012-07-13 09:04:15','admin',NULL,NULL,NULL,NULL),(80,'mahasiswa','5787be38ee03a9ae5360f54d9026465f','mahasiswa@students.del.ac.id',1,NULL,0,NULL,1,'2012-07-13 09:04:37','admin',NULL,NULL,NULL,NULL);

/*Table structure for table `sys_x_role_privilage` */

DROP TABLE IF EXISTS `sys_x_role_privilage`;

CREATE TABLE `sys_x_role_privilage` (
  `sys_x_role_privilage_id` int(11) NOT NULL AUTO_INCREMENT,
  `sys_m_role_id` int(11) NOT NULL,
  `sys_m_privilage_id` int(11) NOT NULL,
  `ucrea` varchar(70) DEFAULT NULL,
  `dcrea` timestamp NULL DEFAULT NULL,
  `icrea` varchar(45) DEFAULT NULL,
  `uupd` varchar(70) DEFAULT NULL,
  `dupd` timestamp NULL DEFAULT NULL,
  `iupd` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`sys_x_role_privilage_id`),
  KEY `fk_role_has_privilage_privilage1_idx` (`sys_m_privilage_id`),
  KEY `fk_role_has_privilage_role1_idx` (`sys_m_role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1;

/*Data for the table `sys_x_role_privilage` */

insert  into `sys_x_role_privilage`(`sys_x_role_privilage_id`,`sys_m_role_id`,`sys_m_privilage_id`,`ucrea`,`dcrea`,`icrea`,`uupd`,`dupd`,`iupd`) values (1,1,53,'admin','2014-07-22 10:42:47',NULL,NULL,NULL,NULL),(2,1,54,'admin','2014-07-22 10:42:56',NULL,NULL,NULL,NULL),(3,1,55,'admin','2014-07-22 10:43:06',NULL,NULL,NULL,NULL),(4,1,56,'admin','2014-07-22 10:43:17',NULL,NULL,NULL,NULL),(5,5,55,'admin','2014-07-22 10:58:58',NULL,NULL,NULL,NULL),(6,5,56,'admin','2014-07-22 10:59:11',NULL,NULL,NULL,NULL),(7,1,57,'admin','2014-07-22 14:30:44',NULL,NULL,NULL,NULL),(8,1,58,'admin','2014-07-22 14:30:52',NULL,NULL,NULL,NULL),(9,1,59,'admin','2014-07-22 14:31:00',NULL,NULL,NULL,NULL),(10,1,60,'admin','2014-07-22 14:31:09',NULL,NULL,NULL,NULL),(11,1,61,'admin','2014-07-22 14:31:17',NULL,NULL,NULL,NULL),(12,1,62,'admin','2014-07-25 14:36:09',NULL,NULL,NULL,NULL),(13,1,63,'admin','2014-07-25 14:54:51',NULL,NULL,NULL,NULL),(14,1,64,'admin','2014-07-25 15:23:22',NULL,NULL,NULL,NULL),(15,1,65,'admin','2014-08-06 20:59:30',NULL,NULL,NULL,NULL),(16,1,66,'admin','2014-08-06 20:59:44',NULL,NULL,NULL,NULL),(17,1,67,'admin','2014-08-06 20:59:57',NULL,NULL,NULL,NULL),(18,1,68,'admin','2014-08-06 21:00:11',NULL,NULL,NULL,NULL),(19,1,69,'admin','2014-08-06 21:00:25',NULL,NULL,NULL,NULL),(20,1,70,'admin','2014-08-06 21:00:38',NULL,NULL,NULL,NULL),(21,1,71,'admin','2014-08-06 22:00:47',NULL,NULL,NULL,NULL),(22,1,72,'admin','2014-08-06 22:01:06',NULL,NULL,NULL,NULL),(23,1,73,'admin','2014-08-06 22:12:52',NULL,NULL,NULL,NULL),(24,1,74,'admin','2014-08-06 22:13:07',NULL,NULL,NULL,NULL),(25,1,75,'admin','2014-08-10 15:19:21',NULL,NULL,NULL,NULL),(26,1,76,'admin','2014-08-10 15:19:35',NULL,NULL,NULL,NULL),(27,1,77,'admin','2014-08-10 15:19:51',NULL,NULL,NULL,NULL),(28,1,78,'admin','2014-08-10 15:20:07',NULL,NULL,NULL,NULL),(29,1,79,'admin','2014-08-10 15:20:22',NULL,NULL,NULL,NULL),(30,1,80,'admin','2014-08-10 15:20:37',NULL,NULL,NULL,NULL),(31,1,81,'admin','2014-08-12 16:56:34',NULL,NULL,NULL,NULL),(32,1,82,'admin','2014-08-12 16:56:45',NULL,NULL,NULL,NULL),(33,1,83,'admin','2014-08-12 16:56:54',NULL,NULL,NULL,NULL);

/*Table structure for table `sys_x_user_role` */

DROP TABLE IF EXISTS `sys_x_user_role`;

CREATE TABLE `sys_x_user_role` (
  `sys_x_user_role_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `sys_m_role_id` int(11) NOT NULL,
  `ucrea` varchar(70) DEFAULT NULL,
  `dcrea` timestamp NULL DEFAULT NULL,
  `icrea` varchar(45) DEFAULT NULL,
  `uupd` varchar(70) DEFAULT NULL,
  `dupd` timestamp NULL DEFAULT NULL,
  `iupd` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`sys_x_user_role_id`),
  KEY `fk_user_has_role_role1_idx` (`sys_m_role_id`),
  KEY `fk_user_has_role_user_idx` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

/*Data for the table `sys_x_user_role` */

insert  into `sys_x_user_role`(`sys_x_user_role_id`,`user_id`,`sys_m_role_id`,`ucrea`,`dcrea`,`icrea`,`uupd`,`dupd`,`iupd`) values (1,76,1,NULL,NULL,NULL,NULL,NULL,NULL),(2,77,2,NULL,NULL,NULL,NULL,NULL,NULL),(3,78,3,NULL,NULL,NULL,NULL,NULL,NULL),(4,79,5,NULL,NULL,NULL,NULL,NULL,NULL),(5,80,4,NULL,NULL,NULL,NULL,NULL,NULL);

/* Trigger structure for table `hrd_t_request_duty_letter` */

DELIMITER $$

/*!50003 DROP TRIGGER*//*!50032 IF EXISTS */ /*!50003 `hrd_insert_request` */$$

/*!50003 CREATE */ /*!50017 DEFINER = 'root'@'localhost' */ /*!50003 TRIGGER `hrd_insert_request` AFTER INSERT ON `hrd_t_request_duty_letter` FOR EACH ROW BEGIN
    DECLARE rem_from TEXT; 
    DECLARE rem_to TEXT; 
    DECLARE rem_cc TEXT; 
    DECLARE rem_subjek VARCHAR(45);
    DECLARE rem_body TEXT; 
    DECLARE rem_status TINYINT;
    DECLARE rem_ucrea VARCHAR(200);
    DECLARE rem_dcrea DATETIME; 
    DECLARE rem_icrea VARCHAR(15);
    DECLARE rem_uupd VARCHAR(200);
    DECLARE rem_dupd DATETIME; 
    DECLARE rem_iupd VARCHAR(15);
    DECLARE rem_sapaan1 VARCHAR (50);
    DECLARE rem_sapaan2 VARCHAR (50);
    DECLARE rem_nama VARCHAR (50);
    DECLARE rem_bodi MEDIUMTEXT;
    
    
    SET rem_from = (SELECT email FROM sys_m_user WHERE login_type = 1 LIMIT 1); 
    SET rem_to = (SELECT email FROM sys_m_user INNER JOIN sys_x_user_role ON sys_m_user.sys_m_user_id = sys_x_user_role.user_id WHERE sys_x_user_role.sys_m_role_id = 7 LIMIT 1); 
    SET rem_cc = (SELECT email FROM sys_m_user INNER JOIN sys_x_user_role ON sys_m_user.sys_m_user_id = sys_x_user_role.user_id WHERE sys_x_user_role.sys_m_role_id = 6 LIMIT 1); 
    SET rem_subjek = 'Request Surat Tugas Baru';
    SET rem_sapaan1 = (SELECT `name` FROM sys_m_role WHERE sys_m_role_id = 6); 
    SET rem_sapaan2 = (SELECT `name` FROM sys_m_role WHERE sys_m_role_id = 7);
    SET rem_nama = (SELECT `nama` FROM hrd_m_pegawai INNER JOIN hrd_t_request_duty_letter ON hrd_m_pegawai.nip = hrd_t_request_duty_letter.requester_id LIMIT 1);
    SET rem_bodi = CONCAT ("Bapak/Ibu",rem_sapaan1, "dan", rem_sapaan2, "Berikut adalah request surat tugas baru dari saudara");
    SET rem_status = 1; 
    SET rem_ucrea = 'test user create'; 
    SET rem_dcrea = 2013-09-03; 
    SET rem_icrea = '172.30.6.21';
    SET rem_uupd = 'test user'; 
    SET rem_dupd = 2013-09-03; 
    SET rem_iupd = '172.30.6.21';
    /*
    INSERT INTO pidel_adm.adm_reminder_outbox (`from`,`to`,cc,subjek,body,`status`,ucrea,dcrea,icrea,uupd,dupd,iupd)
    VALUES (rem_from,rem_to,rem_cc,rem_subjek,rem_bodi,rem_status,rem_ucrea,rem_dcrea,rem_icrea,rem_uupd,rem_dupd,rem_iupd);  
    */
    END */$$


DELIMITER ;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
