<?php

/**
 * This is the model class for table "sys_m_user".
 *
 * The followings are the available columns in table 'sys_m_user':
 * @property integer $sys_m_user_id
 * @property string $username
 * @property string $password
 * @property string $email
 * @property integer $login_type
 * @property string $last_login
 * @property integer $n_tries
 * @property string $last_try
 * @property integer $status
 * @property string $dcrea
 * @property string $ucrea
 * @property string $uupd
 * @property string $dupd
 * @property string $icrea
 * @property string $iupd
 */
class User extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return User the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'sys_m_user';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('username, password, email', 'required'),
            array('login_type, n_tries, status', 'numerical', 'integerOnly' => true),
            array('username', 'length', 'max' => 20),
            array('password, email', 'length', 'max' => 50),
            array('ucrea, uupd', 'length', 'max' => 70),
            array('icrea, iupd', 'length', 'max' => 45),
            array('last_login, last_try, dcrea, dupd', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('sys_m_user_id, username, password, email, login_type, last_login, n_tries, last_try, status, dcrea, ucrea, uupd, dupd, icrea, iupd', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'sys_m_user_id' => 'Sys M User',
            'username' => 'Username',
            'password' => 'Password',
            'email' => 'Email',
            'login_type' => 'Login Type',
            'last_login' => 'Last Login',
            'n_tries' => 'N Tries',
            'last_try' => 'Last Try',
            'status' => 'Status',
            'dcrea' => 'Dcrea',
            'ucrea' => 'Ucrea',
            'uupd' => 'Uupd',
            'dupd' => 'Dupd',
            'icrea' => 'Icrea',
            'iupd' => 'Iupd',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('sys_m_user_id', $this->sys_m_user_id);
        $criteria->compare('username', $this->username, true);
        $criteria->compare('password', $this->password, true);
        $criteria->compare('email', $this->email, true);
        $criteria->compare('login_type', $this->login_type);
        $criteria->compare('last_login', $this->last_login, true);
        $criteria->compare('n_tries', $this->n_tries);
        $criteria->compare('last_try', $this->last_try, true);
        $criteria->compare('status', $this->status);
        $criteria->compare('dcrea', $this->dcrea, true);
        $criteria->compare('ucrea', $this->ucrea, true);
        $criteria->compare('uupd', $this->uupd, true);
        $criteria->compare('dupd', $this->dupd, true);
        $criteria->compare('icrea', $this->icrea, true);
        $criteria->compare('iupd', $this->iupd, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function comparePassword($_password) {
        return($this->password === Yii::app()->digester->md5($_password));
    }

}