<?php

/**
 * This is the model class for table "sys_m_module".
 *
 * The followings are the available columns in table 'sys_m_module':
 * @property string $sys_m_module_id
 * @property string $desc
 *
 * The followings are the available model relations:
 * @property SysMController[] $sysMControllers
 */
class AppModule extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return AppModule the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'sys_m_module';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('sys_m_module_id', 'required'),
			array('sys_m_module_id', 'length', 'max'=>100),
			array('sys_m_module_id', 'unique','message'=>'This module id already exists.'),
			array('desc', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('sys_m_module_id, desc,dcrea, ucrea, uupd, dupd, icrea, iupd', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'sysMControllers' => array(self::HAS_MANY, 'SysMController', 'sys_m_module_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'sys_m_module_id' => 'Sys M Module',
			'desc' => 'Desc',
			'dcrea' => 'Created Date ',
			'ucrea' => 'Created by',
			'uupd' => 'Updated by',
			'dupd' => 'Updated Date ',
			'icrea' => 'Created IP ',
			'iupd' => 'Updated IP ',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('sys_m_module_id',$this->sys_m_module_id,true);
		$criteria->compare('desc',$this->desc,true);
		$criteria->compare('dcrea',$this->dcrea,true);
		$criteria->compare('ucrea',$this->ucrea,true);
		$criteria->compare('uupd',$this->uupd,true);
		$criteria->compare('dupd',$this->dupd,true);
		$criteria->compare('icrea',$this->icrea,true);
		$criteria->compare('iupd',$this->iupd,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	public function afterValidate(){
		parent::afterValidate();
			if ($this->isNewRecord){
                $this->dcrea=new CDbExpression('NOW()');
                $this->ucrea=Yii::app()->user->getName();
            }else{
                $this->dupd=new CDbExpression('NOW()');
                $this->uupd=Yii::app()->user->getName();
            }        
    }
}