<?php

/**
 * This is the model class for table "sys_m_role".
 *
 * The followings are the available columns in table 'sys_m_role':
 * @property integer $sys_m_role_id
 * @property string $name
 * @property string $desc
 */
class Role extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Role the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'sys_m_role';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name', 'length', 'max'=>100),
			array('desc', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('sys_m_role_id, name, desc,dcrea,uupd,ucrea,dupd,icrea,iupd', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'sys_m_role_id' => 'Role ID',
			'name' => 'Name',
			'desc' => 'Desc',
			'dcrea' => 'Created Date ',
			'ucrea' => 'Created by',
			'uupd' => 'Updated by',
			'dupd' => 'Updated Date ',
			'icrea' => 'Created IP ',
			'iupd' => 'Updated IP ',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('sys_m_role_id',$this->sys_m_role_id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('desc',$this->desc,true);
		$criteria->compare('dcrea',$this->dcrea,true);
		$criteria->compare('ucrea',$this->ucrea,true);
		$criteria->compare('dupd',$this->dupd,true);
		$criteria->compare('uupd',$this->uupd,true);
		$criteria->compare('icrea',$this->icrea,true);
		$criteria->compare('iupd',$this->iupd,true);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	public function afterValidate(){
		parent::afterValidate();
			if ($this->isNewRecord){
                $this->dcrea=new CDbExpression('NOW()');
                $this->ucrea=Yii::app()->user->getName();
            }else{
                $this->dupd=new CDbExpression('NOW()');
                $this->uupd=Yii::app()->user->getName();
            }        
    }
}