<?php

/**
 * This is the model class for table "sys_x_role_privilage".
 *
 * The followings are the available columns in table 'sys_x_role_privilage':
 * @property integer $sys_x_role_privilage_id
 * @property integer $sys_m_role_id
 * @property integer $sys_m_privilage_id
 */
class RolePrivilage extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return RolePrivilage the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'sys_x_role_privilage';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('sys_m_role_id, sys_m_privilage_id', 'required'),
			array('sys_m_role_id, sys_m_privilage_id', 'numerical', 'integerOnly'=>true),
			array('sys_m_role_id+sys_m_privilage_id','application.extensions.uniqueMultiColumnValidator','errorMessage' => 'The role-privilage already saved'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('sys_x_role_privilage_id, sys_m_role_id, sys_m_privilage_id,dcrea, ucrea, uupd, dupd, icrea, iupd', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'sys_x_role_privilage_id' => 'ID',
			'sys_m_role_id' => 'Role ID',
			'sys_m_privilage_id' => 'Privilage',
			'dcrea' => 'Created Date ',
			'ucrea' => 'Created by',
			'uupd' => 'Updated by',
			'dupd' => 'Updated Date ',
			'icrea' => 'Created IP ',
			'iupd' => 'Updated IP ',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('sys_x_role_privilage_id',$this->sys_x_role_privilage_id);
		$criteria->compare('sys_m_role_id',$this->sys_m_role_id);
		$criteria->compare('sys_m_privilage_id',$this->sys_m_privilage_id);
		$criteria->compare('dcrea',$this->dcrea,true);
		$criteria->compare('ucrea',$this->ucrea,true);
		$criteria->compare('uupd',$this->uupd,true);
		$criteria->compare('dupd',$this->dupd,true);
		$criteria->compare('icrea',$this->icrea,true);
		$criteria->compare('iupd',$this->iupd,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	public function afterValidate(){
		parent::afterValidate();
			if ($this->isNewRecord){
                $this->dcrea=new CDbExpression('NOW()');
                $this->ucrea=Yii::app()->user->getName();
            }else{
                $this->dupd=new CDbExpression('NOW()');
                $this->uupd=Yii::app()->user->getName();
            }        
           
    }
	public function getRoleText($id)
    {
            $lv4=Role::model()->findByAttributes(array('sys_m_role_id'=>$id));
            return ($lv4->name);
    }
	public function getPrivilageText($id)
    {
            $lv4=Privilage::model()->findByAttributes(array('sys_m_privilage_id'=>$id));
            return ($lv4->name);
    }
	
}