	<?php

/**
 * This is the model class for table "sys_m_user".
 *
 * The followings are the available columns in table 'sys_m_user':
 * @property integer $sys_m_user_id
 * @property string $username
 * @property string $password
 * @property string $email
 * @property string $dcrea
 * @property string $ucrea
 * @property string $uupd
 * @property string $dupd
 * @property string $icrea
 * @property string $iupd
 */
class User extends CActiveRecord
{
		public $verifyCode;
        public $password_repeat;
        
        //untuk change password
        public $oldPass;
        public $oldPass_repeat;
        public $newPass;
        public $newPass_repeat;
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return User the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'sys_m_user';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('username,email,verifyCode,login_type,status', 'required','on'=>array('create','update')),
            array('username', 'length', 'max'=>20,'on'=>array('create','update')),
            array('password, email', 'length', 'max'=>50,'on'=>array('create','update')),
			array('password, password_repeat', 'required','on'=>array('create')),
            array('password','compare','on'=>array('create')),
            array('verifyCode', 'captcha', 'allowEmpty'=>!extension_loaded('gd'),'on'=>array('create','update')), 
            //array('oldPass, newPass, newPass_repeat', 'required','on'=>array('changePass')),
            //array('oldPass, newPass, newPass_repeat', 'length', 'max'=>50,'on'=>array('changePass')),
            //array('oldPass','comp','on'=>array('changePass')),
            //array('newPass','compare','on'=>array('changePass')),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('sys_m_user_id, username, password, email, dcrea, ucrea, uupd, dupd, icrea, iupd', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'sys_m_user_id' => 'Sys M User',
			'username' => 'Username',
			'password' => 'Password',
			'email' => 'Email',
			'dcrea' => 'Created Date ',
			'ucrea' => 'Created by',
			'uupd' => 'Updated by',
			'dupd' => 'Updated Date ',
			'icrea' => 'Created IP ',
			'iupd' => 'Updated IP ',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('sys_m_user_id',$this->sys_m_user_id);
		$criteria->compare('username',$this->username,true);
		$criteria->compare('password',$this->password,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('dcrea',$this->dcrea,true);
		$criteria->compare('ucrea',$this->ucrea,true);
		$criteria->compare('uupd',$this->uupd,true);
		$criteria->compare('dupd',$this->dupd,true);
		$criteria->compare('icrea',$this->icrea,true);
		$criteria->compare('iupd',$this->iupd,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	public function comp()
	{
           $criteria=new CDbCriteria;
           $criteria->compare('password',$this->encrypt($this->password_repeat));
           return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
    }
	public function encrypt($value){
            return md5($value);
	}
	public function afterValidate(){
		parent::afterValidate();
			if ($this->isNewRecord){
                $this->dcrea=new CDbExpression('NOW()');
                $this->ucrea=Yii::app()->user->getName();
            }else{
                $this->dupd=new CDbExpression('NOW()');
                $this->uupd=Yii::app()->user->getName();
            }        
            
            if ($this->oldPass != null){
                $this->password = $this->encrypt($this->newPass);
            }
            else{
                 $this->password = $this->encrypt($this->password);
            }
    }
}