<?php
/* @var $this AppControllerController */
/* @var $model AppController */

$this->breadcrumbs=array(
    'Admin'=>array('../rbac/user/admin'),
    'View Application Controllers',
);

$this->menu=array(
	array('label'=>'Define Application Controller', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('app-controller-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Application Controllers</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'app-controller-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'sys_m_module_id',
		'sys_m_controller_id',
		'desc',
		array(
			'class'=>'CButtonColumn',
		),
	),
)); ?>
