<?php
/* @var $this RolePrivilageController */
/* @var $model RolePrivilage */

$this->breadcrumbs=array(
	'Role Privilages'=>array('index'),
	'Manage',
);

$this->menu=array(
	array('label'=>'List RolePrivilage', 'url'=>array('index')),
	array('label'=>'Create RolePrivilage', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('role-privilage-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Role Privilages</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'role-privilage-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		array(
                    'header' => 'No',
                    'value' => '$row+1',
                ),
		//'sys_x_role_privilage_id',
		array(
                    'name'=>'sys_m_role_id',
                    'header'=>'Role',
                    'type'=>'raw',
                    'value'=>'CHtml::encode($data->getRoleText(CHtml::encode($data->sys_m_role_id)))',
                    'filter'=>Chtml::listData(Role::model()->findAll(),'sys_m_role_id','name'),
                    'sortable'=>true,
                ),
		array(
                    'name'=>'sys_m_privilage_id',
                    'header'=>'Privilage',
                    'type'=>'raw',
                    'value'=>'CHtml::encode($data->getPrivilageText(CHtml::encode($data->sys_m_privilage_id)))',
                    'filter'=>Chtml::listData(Privilage::model()->findAll(),'sys_m_privilage_id','name'),
                    'sortable'=>true,
                ),
		'ucrea',
		//'dcrea',
		//'icrea',
		'uupd',
		//'dupd',
		//'iupd',
		array(
			'class'=>'CButtonColumn',
		),
	),
)); ?>
