<?php
/* @var $this UserController */
/* @var $model User */

$this->breadcrumbs=array(
	'Admin'=>array('../rbac/user/admin'),
	'View Users',
);

$this->menu=array(
	array('label'=>'Define New User', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('user-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Users</h1>
<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>


<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'user-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'username',
		'email',
                array(
                        'name'=>'login_type',                    
                        'value'=> 'Yii::app()->constanta->type_login[$data->login_type]',
                        ),
                'last_login',
                'n_tries',
                'last_try',
		array(
                    'header' => 'Action',
			'class'=>'CButtonColumn',
		),
	),
)); ?>
