<?php

/**
 * This is the model class for table "hrd_h_riwayat_pendidikan".
 *
 * The followings are the available columns in table 'hrd_h_riwayat_pendidikan':
 * @property integer $pendidikan_id
 * @property integer $nidn
 * @property string $perguruan_tinggi
 * @property string $gelar_akademik
 * @property string $t_ijazah
 * @property string $jenjang
 * @property string $created_by
 * @property string $created_date
 * @property string $created_ip
 * @property string $updated_by
 * @property string $updated_date
 * @property string $updated_ip
 *
 * The followings are the available model relations:
 * @property HrdMDosen $nidn0
 */
class HrdHRiwayatPendidikan extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HrdHRiwayatPendidikan the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hrd_h_riwayat_pendidikan';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
            array('nidn', 'required'),
			array('pendidikan_id, nidn', 'numerical', 'integerOnly'=>true),
			array('perguruan_tinggi, created_ip, updated_ip', 'length', 'max'=>200),
			array('gelar_akademik', 'length', 'max'=>10),
			array('jenjang', 'length', 'max'=>5),
			array('created_by, updated_by', 'length', 'max'=>15),
			array('t_ijazah, created_date, updated_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('pendidikan_id, nidn, perguruan_tinggi, gelar_akademik, t_ijazah, jenjang, created_by, created_date, created_ip, updated_by, updated_date, updated_ip', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'nidn0' => array(self::BELONGS_TO, 'HrdMDosen', 'nidn'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'pendidikan_id' => 'Pendidikan',
			'nidn' => 'Nidn',
			'perguruan_tinggi' => 'Perguruan Tinggi',
			'gelar_akademik' => 'Gelar Akademik',
			't_ijazah' => 'T Ijazah',
			'jenjang' => 'Jenjang',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'created_ip' => 'Created Ip',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
			'updated_ip' => 'Updated Ip',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('pendidikan_id',$this->pendidikan_id);
		$criteria->compare('nidn',$this->nidn);
		$criteria->compare('perguruan_tinggi',$this->perguruan_tinggi,true);
		$criteria->compare('gelar_akademik',$this->gelar_akademik,true);
		$criteria->compare('t_ijazah',$this->t_ijazah,true);
		$criteria->compare('jenjang',$this->jenjang,true);
		$criteria->compare('created_by',$this->created_by,true);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('created_ip',$this->created_ip,true);
		$criteria->compare('updated_by',$this->updated_by,true);
		$criteria->compare('updated_date',$this->updated_date,true);
		$criteria->compare('updated_ip',$this->updated_ip,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

    protected function afterValidate(){
        if ($this->isNewRecord){
            $this->created_date=new CDbExpression('NOW()');
            $this->created_by=Yii::app()->user->getId();
            $this->created_ip=Yii::app()->request->getUserHostAddress();


        }else{
            $this->updated_date=new CDbExpression('NOW()');
            $this->updated_by=Yii::app()->user->getId();
            $this->updated_ip=Yii::app()->request->getUserHostAddress();
        }
    }
}