<?php

/**
 * This is the model class for table "hrd_h_riwayat_pengajaran".
 *
 * The followings are the available columns in table 'hrd_h_riwayat_pengajaran':
 * @property integer $pengajaran_id
 * @property integer $nidn
 * @property integer $semester
 * @property string $kode_mk
 * @property string $nama_mk
 * @property string $kode_kelas
 * @property string $created_by
 * @property string $created_date
 * @property string $created_ip
 * @property string $updated_by
 * @property string $updated_date
 * @property string $updated_ip
 *
 * The followings are the available model relations:
 * @property HrdMDosen $nidn0
 */
class HrdHRiwayatPengajaran extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HrdHRiwayatPengajaran the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hrd_h_riwayat_pengajaran';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nidn', 'required'),
			array('nidn, semester', 'numerical', 'integerOnly'=>true),
			array('kode_mk', 'length', 'max'=>10),
			array('nama_mk, created_ip, updated_ip', 'length', 'max'=>200),
			array('kode_kelas', 'length', 'max'=>5),
			array('created_by, updated_by', 'length', 'max'=>15),
			array('created_date, updated_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('pengajaran_id, nidn, semester, kode_mk, nama_mk, kode_kelas, created_by, created_date, created_ip, updated_by, updated_date, updated_ip', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'nidn0' => array(self::BELONGS_TO, 'HrdMDosen', 'nidn'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'pengajaran_id' => 'Pengajaran',
			'nidn' => 'Nidn',
			'semester' => 'Semester',
			'kode_mk' => 'Kode Mk',
			'nama_mk' => 'Nama Mk',
			'kode_kelas' => 'Kode Kelas',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'created_ip' => 'Created Ip',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
			'updated_ip' => 'Updated Ip',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('pengajaran_id',$this->pengajaran_id);
		$criteria->compare('nidn',$this->nidn);
		$criteria->compare('semester',$this->semester);
		$criteria->compare('kode_mk',$this->kode_mk,true);
		$criteria->compare('nama_mk',$this->nama_mk,true);
		$criteria->compare('kode_kelas',$this->kode_kelas,true);
		$criteria->compare('created_by',$this->created_by,true);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('created_ip',$this->created_ip,true);
		$criteria->compare('updated_by',$this->updated_by,true);
		$criteria->compare('updated_date',$this->updated_date,true);
		$criteria->compare('updated_ip',$this->updated_ip,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

    protected function afterValidate(){
        if ($this->isNewRecord){
            $this->created_date=new CDbExpression('NOW()');
            $this->created_by=Yii::app()->user->getId();
            $this->created_ip=Yii::app()->request->getUserHostAddress();


        }else{
            $this->updated_date=new CDbExpression('NOW()');
            $this->updated_by=Yii::app()->user->getId();
            $this->updated_ip=Yii::app()->request->getUserHostAddress();
        }
    }
}