<?php

/**
 * This is the model class for table "hrd_d_request_duty_letter".
 *
 * The followings are the available columns in table 'hrd_d_request_duty_letter':
 * @property integer $id
 * @property integer $id_hrd_t_request_duty_letter
 * @property string $nama_petugas
 * @property string $nama_pengemban_tugas
 * @property string $keterangan
 * @property string $created_by
 * @property string $created_date
 * @property string $created_ip
 * @property string $updated_by
 * @property string $updated_date
 * @property string $updated_ip
 *
 * The followings are the available model relations:
 * @property HrdTRequestDutyLetter $idHrdTRequestDutyLetter
 */
class HrdDRequestDutyLetter extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HrdDRequestDutyLetter the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hrd_d_request_duty_letter';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_hrd_t_request_duty_letter, nama_petugas, nama_pengemban_tugas, keterangan', 'required'),
			array('id_hrd_t_request_duty_letter', 'numerical', 'integerOnly'=>true),
			array('nama_petugas, nama_pengemban_tugas', 'length', 'max'=>100),
			array('created_by, updated_by', 'length', 'max'=>15),
			array('created_ip, updated_ip', 'length', 'max'=>200),
			array('created_date, updated_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, id_hrd_t_request_duty_letter, nama_petugas, nama_pengemban_tugas, keterangan, created_by, created_date, created_ip, updated_by, updated_date, updated_ip', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idHrdTRequestDutyLetter' => array(self::BELONGS_TO, 'HrdTRequestDutyLetter', 'id_hrd_t_request_duty_letter'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_hrd_t_request_duty_letter' => 'Id Hrd T Request Duty Letter',
			'nama_petugas' => 'Nama Petugas',
			'nama_pengemban_tugas' => 'Nama Pengemban Tugas',
			'keterangan' => 'Keterangan',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'created_ip' => 'Created Ip',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
			'updated_ip' => 'Updated Ip',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_hrd_t_request_duty_letter',$this->id_hrd_t_request_duty_letter);
		$criteria->compare('nama_petugas',$this->nama_petugas,true);
		$criteria->compare('nama_pengemban_tugas',$this->nama_pengemban_tugas,true);
		$criteria->compare('keterangan',$this->keterangan,true);
		$criteria->compare('created_by',$this->created_by,true);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('created_ip',$this->created_ip,true);
		$criteria->compare('updated_by',$this->updated_by,true);
		$criteria->compare('updated_date',$this->updated_date,true);
		$criteria->compare('updated_ip',$this->updated_ip,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	protected function afterValidate(){
        if ($this->isNewRecord){
            $this->created_date=new CDbExpression('NOW()');
            $this->created_by=Yii::app()->user->getId();
            $this->created_ip=Yii::app()->request->getUserHostAddress();


        }else{
            $this->updated_date=new CDbExpression('NOW()');
            $this->updated_by=Yii::app()->user->getId();
            $this->updated_ip=Yii::app()->request->getUserHostAddress();
        }
    }
}