<?php

/**
 * This is the model class for table "hrd_m_duty_letter".
 *
 * The followings are the available columns in table 'hrd_m_duty_letter':
 * @property integer $duty_letter_id
 * @property integer $request_id
 * @property string $duty_letter_number
 * @property string $duty_letter_date
 * @property integer $signed_by
 * @property string $depart_transport
 * @property string $return_transport
 * @property string $route_journey
 * @property string $hostelry
 * @property integer $sppd_duration
 * @property integer $status_id
 * @property string $task_shifting
 * @property string $created_by
 * @property string $created_date
 * @property string $created_ip
 * @property string $updated_by
 * @property string $updated_date
 * @property string $updated_ip
 */
class HrdMDutyLetter extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HrdMDutyLetter the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hrd_m_duty_letter';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('request_id, duty_letter_number, duty_letter_date, signed_by, depart_transport, return_transport, route_journey, hostelry, sppd_duration, status_id, task_shifting', 'required'),
			array('request_id, signed_by, sppd_duration, status_id', 'numerical', 'integerOnly'=>true),
			array('duty_letter_number, depart_transport, return_transport', 'length', 'max'=>50),
			array('route_journey, hostelry', 'length', 'max'=>200),
			array('created_by, updated_by', 'length', 'max'=>100),
			array('created_ip, updated_ip', 'length', 'max'=>15),
			array('created_date, updated_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('duty_letter_id, request_id, duty_letter_number, duty_letter_date, signed_by, depart_transport, return_transport, route_journey, hostelry, sppd_duration, status_id, task_shifting, created_by, created_date, created_ip, updated_by, updated_date, updated_ip', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'duty_letter_id' => 'Duty Letter',
			'request_id' => 'Request',
			'duty_letter_number' => 'Duty Letter Number',
			'duty_letter_date' => 'Duty Letter Date',
			'signed_by' => 'Signed By',
			'depart_transport' => 'Depart Transport',
			'return_transport' => 'Return Transport',
			'route_journey' => 'Route Journey',
			'hostelry' => 'Hostelry',
			'sppd_duration' => 'Sppd Duration',
			'status_id' => 'Status',
			'task_shifting' => 'Task Shifting',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'created_ip' => 'Created Ip',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
			'updated_ip' => 'Updated Ip',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('duty_letter_id',$this->duty_letter_id);
		$criteria->compare('request_id',$this->request_id);
		$criteria->compare('duty_letter_number',$this->duty_letter_number,true);
		$criteria->compare('duty_letter_date',$this->duty_letter_date,true);
		$criteria->compare('signed_by',$this->signed_by);
		$criteria->compare('depart_transport',$this->depart_transport,true);
		$criteria->compare('return_transport',$this->return_transport,true);
		$criteria->compare('route_journey',$this->route_journey,true);
		$criteria->compare('hostelry',$this->hostelry,true);
		$criteria->compare('sppd_duration',$this->sppd_duration);
		$criteria->compare('status_id',$this->status_id);
		$criteria->compare('task_shifting',$this->task_shifting,true);
		$criteria->compare('created_by',$this->created_by,true);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('created_ip',$this->created_ip,true);
		$criteria->compare('updated_by',$this->updated_by,true);
		$criteria->compare('updated_date',$this->updated_date,true);
		$criteria->compare('updated_ip',$this->updated_ip,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}