<?php

/**
 * This is the model class for table "hrd_t_report_duty_letter".
 *
 * The followings are the available columns in table 'hrd_t_report_duty_letter':
 * @property integer $report_duty_letter_id
 * @property integer $duty_letter_id
 * @property string $report_date
 * @property string $report_file_name
 * @property string $created_by
 * @property string $created_ip
 * @property string $created_date
 * @property string $updated_ip
 * @property string $updated_by
 * @property string $updated_date
 */
class HrdTReportDutyLetter extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HrdTReportDutyLetter the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hrd_t_report_duty_letter';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		/*
		return array(
			array('duty_letter_id, report_date', 'required'),
			array('duty_letter_id', 'numerical', 'integerOnly'=>true),
			array('report_file_name', 'length', 'max'=>100),
			array('created_by, updated_by', 'length', 'max'=>200),
			array('created_ip, updated_ip', 'length', 'max'=>15),
			array('created_date, updated_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('report_duty_letter_id, duty_letter_id, report_date, report_file_name, created_by, created_ip, created_date, updated_ip, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
		*/
		return array(
			array('duty_letter_id, report_date, report_file_name', 'required'),
                        array('file_report', 'file','types'=>'pdf','maxSize'=>1024 * 1024 * 2, 'tooLarge'=>'File has to be smaller than 2MB', 'wrongType'=>'Only pdf allowed'),
			array('duty_letter_id', 'numerical', 'integerOnly'=>true),
			array('report_file_name', 'length', 'max'=>45),
			array('created_by, updated_by', 'length', 'max'=>200),
			array('created_ip, updated_ip', 'length', 'max'=>15),
			array('created_date, updated_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('report_duty_letter_id, duty_letter_id, report_date, report_file_name, created_by, created_ip, created_date, updated_ip, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'report_duty_letter_id' => 'Report Duty Letter',
			'duty_letter_id' => 'Duty Letter',
			'report_date' => 'Report Date',
			'report_file_name' => 'Report File Name',
			'created_by' => 'Created By',
			'created_ip' => 'Created Ip',
			'created_date' => 'Created Date',
			'updated_ip' => 'Updated Ip',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('report_duty_letter_id',$this->report_duty_letter_id);
		$criteria->compare('duty_letter_id',$this->duty_letter_id);
		$criteria->compare('report_date',$this->report_date,true);
		$criteria->compare('report_file_name',$this->report_file_name,true);
		$criteria->compare('created_by',$this->created_by,true);
		$criteria->compare('created_ip',$this->created_ip,true);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_ip',$this->updated_ip,true);
		$criteria->compare('updated_by',$this->updated_by,true);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	// New
	
	protected function afterValidate(){
		if ($this->isNewRecord){
			$this->created_date=new CDbExpression('NOW()');
			$this->created_by=Yii::app()->user->getId();
			$this->created_ip=Yii::app()->request->getUserHostAddress();
		} else {
			$this->updated_date=new CDbExpression('NOW()');
			$this->updated_by=Yii::app()->user->getId();
			$this->updated_ip=Yii::app()->request->getUserHostAddress();
            }
    }
}