<?php
/* @var $this HrdHRequestDutyLetterController */
/* @var $model HrdHRequestDutyLetter */

$this->breadcrumbs=array(
	'Hrd Hrequest Duty Letters'=>array('index'),
	'Manage',
);

$this->menu=array(
	array('label'=>'List HrdHRequestDutyLetter', 'url'=>array('index')),
	array('label'=>'Create HrdHRequestDutyLetter', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#hrd-hrequest-duty-letter-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Hrd Hrequest Duty Letters</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'hrd-hrequest-duty-letter-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'rdl_history_id',
		'request_id',
		'status_id',
		'created_by',
		'created_date',
		'created_ip',
		/*
		'updated_by',
		'updated_date',
		'updated_ip',
		*/
		array(
			'class'=>'CButtonColumn',
		),
	),
)); ?>
