<?php
/* @var $this HrdTReportDutyLetterController */
/* @var $model HrdTReportDutyLetter */

$this->breadcrumbs=array(
	'Hrd Treport Duty Letters'=>array('index'),
	'Manage',
);

$this->menu=array(
	array('label'=>'List HrdTReportDutyLetter', 'url'=>array('index')),
	array('label'=>'Create HrdTReportDutyLetter', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#hrd-treport-duty-letter-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Hrd Treport Duty Letters</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'hrd-treport-duty-letter-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'report_duty_letter_id',
		'duty_letter_id',
		'report_date',
		'report_file_name',
		'created_by',
		'created_ip',
		/*
		'created_date',
		'updated_ip',
		'updated_by',
		'updated_date',
		*/
		array(
			'class'=>'CButtonColumn',
		),
	),
)); ?>
